package jp.gr.java_conf.wutse.purewiki;

import java.util.HashMap;
import java.util.Map;

import jp.gr.java_conf.wutse.purewiki.syntax.BlockSyntax;
import jp.gr.java_conf.wutse.purewiki.syntax.LineSyntax;

public class PureWikiContext {
	public static final String RUNNING = "RUNNING";
	public static final String END = "END";

	private PureWikiEngine engine = null;
	private String status = "RUNNING";
	private PureWikiData wikiData = null;
	private String originalLine = null;
	private String line = null;
	private BlockSyntax currentBlockSyntax = null;
	private LineSyntax currentLineSyntax = null;
	private boolean enableHtmlEncode = true;
	private boolean enableLineSyntax = true;
	private boolean enableWordSyntax = true;
	private Map<String, Object> attributeMap = new HashMap<String, Object>();

	public PureWikiEngine getEngine() {
		return engine;
	}

	public void setEngine(PureWikiEngine engine) {
		this.engine = engine;
	}

	public PureWikiData getWikiData() {
		return wikiData;
	}

	public void setWikiData(PureWikiData wikiData) {
		this.wikiData = wikiData;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public boolean isEnd() {
		return END.equals(status);
	}

	public String getOriginalLine() {
		return originalLine;
	}

	public void setOriginalLine(String originalLine) {
		this.originalLine = originalLine;
	}

	public String getLine() {
		return line;
	}

	public void setLine(String line) {
		this.line = line;
	}

	public BlockSyntax getCurrentBlockSyntax() {
		return currentBlockSyntax;
	}

	public void setCurrentBlockSyntax(BlockSyntax currentBlockSyntax) {
		this.currentBlockSyntax = currentBlockSyntax;
	}

	public LineSyntax getCurrentLineSyntax() {
		return currentLineSyntax;
	}

	public void setCurrentLineSyntax(LineSyntax currentLineSyntax) {
		this.currentLineSyntax = currentLineSyntax;
	}

	public boolean isEnableHtmlEncode() {
		return enableHtmlEncode;
	}

	public void setEnableHtmlEncode(boolean enableHtmlEncode) {
		this.enableHtmlEncode = enableHtmlEncode;
	}

	public boolean isEnableLineSyntax() {
		return enableLineSyntax;
	}

	public void setEnableLineSyntax(boolean enableLineSyntax) {
		this.enableLineSyntax = enableLineSyntax;
	}

	public boolean isEnableWordSyntax() {
		return enableWordSyntax;
	}

	public void setEnableWordSyntax(boolean enableWordSyntax) {
		this.enableWordSyntax = enableWordSyntax;
	}

	public void setAttribute(String attributeName, Object value) {
		attributeMap.put(attributeName, value);
	}

	public Object getAttribute(String attributeName) {
		return attributeMap.get(attributeName);
	}

}
