package mirrg.util;

import static mirrg.util.HString.*;
import static org.junit.Assert.*;

import org.junit.Test;

public class TestHString
{

	@Test
	public void test_getIndexedFilePath()
	{
		assertEquals("aaa.txt", getIndexedFilePath("aaa.txt", 0));
		assertEquals("b\\aaa.txt", getIndexedFilePath("b\\aaa.txt", 0));
		assertEquals("c:\\aaa.txt", getIndexedFilePath("c:\\aaa.txt", 0));
		assertEquals("c:\\b\\aaa.txt", getIndexedFilePath("c:\\b\\aaa.txt", 0));
		assertEquals("aaa_1.txt", getIndexedFilePath("aaa.txt", 1));
		assertEquals("b\\aaa_1.txt", getIndexedFilePath("b\\aaa.txt", 1));
		assertEquals("c:\\aaa_1.txt", getIndexedFilePath("c:\\aaa.txt", 1));
		assertEquals("c:\\b\\aaa_1.txt", getIndexedFilePath("c:\\b\\aaa.txt", 1));
		assertEquals("aaa_2.txt", getIndexedFilePath("aaa.txt", 2));
		assertEquals("b\\aaa_2.txt", getIndexedFilePath("b\\aaa.txt", 2));
		assertEquals("c:\\aaa_2.txt", getIndexedFilePath("c:\\aaa.txt", 2));
		assertEquals("c:\\b\\aaa_2.txt", getIndexedFilePath("c:\\b\\aaa.txt", 2));
	}

	@Test
	public void test_toString()
	{
		assertEquals("0", HString.toString(0.0));
		assertEquals("190", HString.toString(190D));
		assertEquals("-56", HString.toString(-56));
		assertEquals("1000", HString.toString(10E2));
		assertEquals("1000.0001", HString.toString(10.000001E2));
		assertEquals("0.010000001", HString.toString(10.000001E-3));
		assertEquals("0.1234567", HString.toString(0.1234567));
		assertEquals("0.1234567891", HString.toString(0.1234567891));
		assertEquals("0.12345678912345678", HString.toString(0.12345678912345678912345));
		assertEquals("1000000000000000000", HString.toString(1000000000000000000D));
		assertEquals("-0", HString.toString(-0.0));
	}

	@Test
	public void test()
	{
		assertEquals("C:\\a\\b", deleteExtension("C:\\a\\b.csv"));
		assertEquals("C:\\a\\b.", deleteExtension("C:\\a\\b."));
		assertEquals("C:\\a\\b", deleteExtension("C:\\a\\b"));
		assertEquals("C:\\a\\b.csv", deleteExtension("C:\\a\\b.csv.txt"));
		assertEquals("C:\\a.b\\c", deleteExtension("C:\\a.b\\c"));
	}

}
