package mirrg.simulation.cart.almandine.gui.toolcursor;

import java.awt.Point;
import java.awt.event.MouseEvent;

import mirrg.event.nitrogen.HNitrogenEvent;
import mirrg.event.nitrogen.INitrogenEventManager;
import mirrg.simulation.cart.almandine.GameAlmandine;
import mirrg.simulation.cart.almandine.IFrameGameAlmandine;
import mirrg.simulation.cart.almandine.factory.Factory;

public abstract class ToolCursor
{

	protected IFrameGameAlmandine frameGameAlmandine;
	public INitrogenEventManager eventManager = HNitrogenEvent.createInstance();

	public ToolCursor(IFrameGameAlmandine frameGameAlmandine)
	{
		this.frameGameAlmandine = frameGameAlmandine;
	}

	protected GameAlmandine getGame()
	{
		return frameGameAlmandine.getGame();
	}

	protected Factory getFactory()
	{
		return getGame().factory;
	}

	public abstract String getLocalizedName();

	public abstract String getLocalizedDescription();

	protected Point getCoord(MouseEvent e)
	{
		return new Point(frameGameAlmandine.getXCoord(e.getX()), frameGameAlmandine.getYCoord(e.getY()));
	}

	protected Point getPoint(MouseEvent e)
	{
		return new Point(e.getX(), e.getY());
	}

}
