package mirrg.simulation.cart.almandine.gui.toolcursor;

import java.awt.event.KeyEvent;

import javax.swing.KeyStroke;

public class ShortcutKey
{

	public int keyCode;
	public boolean shift;
	public boolean control;
	public boolean alt;

	public ShortcutKey(int keyCode)
	{
		this.keyCode = keyCode;
	}

	public boolean match(KeyEvent e)
	{
		if (this.keyCode != e.getKeyCode()) return false;
		if (shift != e.isShiftDown()) return false;
		if (control != e.isControlDown()) return false;
		if (alt != e.isAltDown()) return false;
		return true;
	}

	public ShortcutKey shift()
	{
		shift = true;
		return this;
	}

	public ShortcutKey control()
	{
		control = true;
		return this;
	}

	public ShortcutKey alt()
	{
		alt = true;
		return this;
	}

	public String getText()
	{
		StringBuilder sb = new StringBuilder();
		if (shift) sb.append("S");
		if (control) sb.append("C");
		if (alt) sb.append("A");
		if (sb.length() >= 1) {
			return KeyEvent.getKeyText(keyCode) + "[" + sb.toString() + "]";
		} else {
			return KeyEvent.getKeyText(keyCode);
		}
	}

	public KeyStroke toKeyStroke()
	{
		int modifiers = 0;

		if (shift) modifiers |= KeyEvent.SHIFT_DOWN_MASK;
		if (control) modifiers |= KeyEvent.CTRL_DOWN_MASK;
		if (alt) modifiers |= KeyEvent.ALT_DOWN_MASK;

		return KeyStroke.getKeyStroke(keyCode, modifiers);
	}

}
