package mirrg.simulation.cart.almandine.mods.vanilla.toolcursors;

import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseEvent;

import mirrg.applet.nitrogen.events.NitrogenEventMouse;
import mirrg.applet.nitrogen.events.NitrogenEventMouseMotion;
import mirrg.simulation.cart.almandine.IFrameGameAlmandine;
import mirrg.simulation.cart.almandine.factory.Entity;
import mirrg.simulation.cart.almandine.factory.Factory;
import mirrg.simulation.cart.almandine.factory.IllegalEntityIdException;
import mirrg.simulation.cart.almandine.gui.toolcursor.NitrogenEventToolCursor;
import mirrg.simulation.cart.almandine.gui.toolcursor.ToolCursor;

public abstract class ToolCursorPutConnectionBase<E extends Entity> extends ToolCursor
{

	public ToolCursorPutConnectionBase(IFrameGameAlmandine frameGameAlmandine)
	{
		super(frameGameAlmandine);

		eventManager.register(NitrogenEventMouse.Pressed.class, e -> {
			mouseMoved(e.mouseEvent);
			mouseDragged(e.mouseEvent);
		});
		eventManager.register(NitrogenEventMouse.Released.class, e -> {
			try {

				if (begin == null) return;
				mouseDragged(e.mouseEvent);
				if (end == null) return;
				if (begin == end) return;

				add(begin, end);

			} finally {
				begin = null;
				pointEnd = null;
				end = null;
			}
		});
		eventManager.register(NitrogenEventMouseMotion.Dragged.class, e -> {
			mouseDragged(e.mouseEvent);
		});
		eventManager.register(NitrogenEventMouseMotion.Moved.class, e -> {
			mouseMoved(e.mouseEvent);
		});
		eventManager.register(NitrogenEventToolCursor.Render.class, e -> {
			if (begin == null) return;

			frameGameAlmandine.doTranslate(e.graphics, () -> {

				if (end != null) {
					// 終了地点でスロットをホバー

				// 線
				e.graphics.setColor(new Color(0xff0000));
				try {
					Point pointBegin = begin.getPoint();
					Point pointEnd = end.getPoint();
					e.graphics.drawLine(pointBegin.x, pointBegin.y, pointEnd.x, pointEnd.y);
				} catch (IllegalEntityIdException e2) {

				}

				// 枠
				try {
					begin.drawHover(e.graphics);
					end.drawHover(e.graphics);
				} catch (IllegalEntityIdException e2) {

				}

			} else if (pointEnd != null) {
				// 終了地点にスロットが無いが、どこかをポイントしている

				// 線
				e.graphics.setColor(new Color(0xff0000));
				try {
					Point pointBegin = begin.getPoint();
					e.graphics.drawLine(pointBegin.x, pointBegin.y, pointEnd.x, pointEnd.y);
				} catch (IllegalEntityIdException e2) {

				}

				// 枠
				try {
					begin.drawHover(e.graphics);
				} catch (IllegalEntityIdException e2) {

				}

			} else {
				// まだ始点を決めていない

				// 枠
				try {
					begin.drawHover(e.graphics);
				} catch (IllegalEntityIdException e2) {

				}

			}

		}	);
		});
	}

	private E begin;
	private Point pointEnd;
	private E end;

	public abstract Class<E> getClassEntity();

	public void mouseMoved(MouseEvent e)
	{
		begin = Factory.filterHover(Factory.filterClass(getFactory().getEntities(), getClassEntity()), getCoord(e)).stream()
			.findFirst()
			.orElse(null);
	}

	public void mouseDragged(MouseEvent e)
	{
		if (begin == null) return;

		pointEnd = getCoord(e);
		end = Factory.filterHover(Factory.filterClass(getFactory().getEntities(), getClassEntity()), getCoord(e)).stream()
			.findFirst()
			.orElse(null);
	}

	protected abstract void add(E begin, E end);

}
