package mirrg.simulation.cart.almandine.mods.vanilla.toolcursors;

import java.awt.event.MouseEvent;

import mirrg.simulation.cart.almandine.IFrameGameAlmandine;
import mirrg.simulation.cart.almandine.factory.Entity;
import mirrg.simulation.cart.almandine.factory.Factory;
import mirrg.simulation.cart.almandine.gui.toolcursor.ToolCursor;

public class ToolCursorProperty extends ToolCursor
{

	public ToolCursorProperty(IFrameGameAlmandine frameGameAlmandine)
	{
		super(frameGameAlmandine);

		new ModuleClickEntity<Entity>(frameGameAlmandine, button -> button == MouseEvent.BUTTON1, (e, entity) -> {
			entity.openWindowProperty(frameGameAlmandine);
		}, (factory, point) -> {
			return Factory.filterHover(factory.getEntities(), point);
		}).apply(this);
	}

	@Override
	public String getLocalizedName()
	{
		return "プロパティ";
	}

	@Override
	public String getLocalizedDescription()
	{
		return "左クリックした対象のプロパティウィンドウを表示";
	}

}
