package mirrg.simulation.cart.almandine.mods.vanilla.stations;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;

import javax.swing.JButton;

import mirrg.simulation.cart.almandine.GameAlmandine;
import mirrg.simulation.cart.almandine.facroty.property.IDialogProperty;
import mirrg.simulation.cart.almandine.factory.IllegalEntityIdException;
import mirrg.simulation.cart.almandine.mods.vanilla.parts.StationBase;
import mirrg.swing.helium.GroupBuilder;

import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.SyntaxConstants;
import org.fife.ui.rtextarea.RTextScrollPane;

import com.thoughtworks.xstream.annotations.XStreamOmitField;

public class StationScripted extends StationBase
{

	@Deprecated
	public StationScripted()
	{
		super();
	}

	public StationScripted(GameAlmandine game, Point point, int radius)
	{
		super(game, point, radius);
	}

	@Override
	protected int getColor()
	{
		return 0xcc005f;
	}

	@Override
	protected void addProperty(IDialogProperty dialogProperty)
	{
		super.addProperty(dialogProperty);

		dialogProperty.addPropertyBoolean("Compile OK", () -> ai != null ? ai.compileOk : false, compileOk -> {
			return false;
		});
		{
			// エディタ
			RSyntaxTextArea syntaxTextArea = new RSyntaxTextArea();
			syntaxTextArea.setSyntaxEditingStyle(SyntaxConstants.SYNTAX_STYLE_JAVASCRIPT);
			syntaxTextArea.setText(script);
			syntaxTextArea.setFont(new Font(Font.MONOSPACED, Font.PLAIN, 12));
			syntaxTextArea.setWhitespaceVisible(false);
			syntaxTextArea.setMarginLineEnabled(false);
			syntaxTextArea.setEOLMarkersVisible(false);
			syntaxTextArea.setFadeCurrentLineHighlight(false);
			syntaxTextArea.setHighlightCurrentLine(false);
			syntaxTextArea.setMarkOccurrences(true);
			syntaxTextArea.setRoundedSelectionEdges(true);

			RTextScrollPane textScrollPane = new RTextScrollPane(syntaxTextArea);
			textScrollPane.setPreferredSize(new Dimension(400, 400));

			// コンパイルボタン
			JButton buttonCompile = new JButton("コンパイル");
			buttonCompile.addActionListener(e -> {
				setScript(syntaxTextArea.getText());
			});

			//

			dialogProperty.addComponent(GroupBuilder.group(textScrollPane));
			dialogProperty.addComponent(GroupBuilder.group(buttonCompile));
		}
	}

	public String script = "function route(factory, station) {}";

	public void setScript(String script)
	{
		this.script = script;
		ai = null;
	}

	/**
	 * null: まだコンパイルを試みていない
	 */
	@XStreamOmitField
	public AIStation ai = null;

	@Override
	public void tick(double deltaSecond) throws IllegalEntityIdException
	{
		if (!getCartPrimary().isPresent()) return;
		if (ai == null) ai = AIStation.compile(script);

		ai.run(game.factory, this);

	}

}
