package mirrg.simulation.cart.almandine.mods.vanilla.stations;

import java.awt.Point;
import java.util.Optional;

import mirrg.simulation.cart.almandine.GameAlmandine;
import mirrg.simulation.cart.almandine.factory.IllegalEntityIdException;
import mirrg.simulation.cart.almandine.mods.vanilla.enchant.EnchantCartCover;
import mirrg.simulation.cart.almandine.mods.vanilla.primaries.Cart;

public class StationCovering extends StationCoverBase
{

	@Deprecated
	public StationCovering()
	{
		super();
	}

	public StationCovering(GameAlmandine game, Point point, int radius, double duration)
	{
		super(game, point, radius, duration);
	}

	@Override
	protected int getColor()
	{
		return 0x85c693;
	}

	@Override
	protected boolean shouldAction(double deltaSecond, Cart cart) throws IllegalEntityIdException
	{
		Optional<EnchantCartCover> optionalCover = getCover(cart);
		return !optionalCover.isPresent() || !optionalCover.get().enabled;
	}

	@Override
	protected void action(double deltaSecond, Cart cart) throws IllegalEntityIdException
	{
		Optional<EnchantCartCover> optionalCover = getCover(cart);
		if (optionalCover.isPresent()) {
			optionalCover.get().enabled = true;
		} else {
			EnchantCartCover enchant = new EnchantCartCover();
			enchant.enabled = true;
			cart.enchants.add(enchant);
		}
	}

}
