package mirrg.simulation.cart.almandine.mods.vanilla.slots;

import java.util.Optional;

import mirrg.simulation.cart.almandine.GameAlmandine;
import mirrg.simulation.cart.almandine.facroty.property.IDialogProperty;
import mirrg.simulation.cart.almandine.factory.IllegalEntityIdException;
import mirrg.simulation.cart.almandine.mods.vanilla.parts.Bound;
import mirrg.simulation.cart.almandine.mods.vanilla.parts.SlotBase;
import mirrg.simulation.cart.almandine.mods.vanilla.stackslab.ManagerEnvironment;
import mirrg.simulation.cart.almandine.mods.vanilla.stackslab.SlotSlab;

public class SlotModule extends SlotBase
{

	@Deprecated
	public SlotModule()
	{
		super();
	}

	public SlotSlab slot;

	public SlotModule(GameAlmandine game, Bound bound, int capacity) throws IllegalEntityIdException
	{
		super(game, bound);
		slot = new SlotSlab(capacity);
	}

	@Override
	public Optional<SlotSlab> getSlotSlab()
	{
		return Optional.of(slot);
	}

	@Override
	protected void addProperty(IDialogProperty dialogProperty)
	{
		super.addProperty(dialogProperty);
		slot.addProperty(game.factory, dialogProperty);
	}

	@Override
	public void tick(double deltaSecond) throws IllegalEntityIdException
	{
		if (slot.stack != null) {
			slot.stack.tick(game.factory, deltaSecond, ManagerEnvironment.getEnvironment(game, getPoint()));
		}
	}

}
