package mirrg.simulation.cart.almandine.mods.vanilla.primaries;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;

import mirrg.simulation.cart.almandine.GameAlmandine;
import mirrg.simulation.cart.almandine.facroty.property.IDialogProperty;
import mirrg.simulation.cart.almandine.factory.IllegalEntityIdException;
import mirrg.simulation.cart.almandine.mods.vanilla.parts.SlotBase;
import mirrg.simulation.cart.almandine.mods.vanilla.stackslab.ManagerEnvironment;
import mirrg.simulation.cart.almandine.mods.vanilla.stackslab.SlotSlab;

public class Arm extends PrimaryConnection<SlotBase>
{

	@Deprecated
	public Arm()
	{
		super();
	}

	/**
	 * [second]
	 */
	public double position = 0;

	/**
	 * [second]
	 */
	public double duration;

	public SlotSlab slot;

	public Arm(GameAlmandine game, SlotBase begin, SlotBase end, double duration) throws IllegalEntityIdException
	{
		super(game, begin, end);
		this.duration = duration;
		slot = new SlotSlab(1);
	}

	@Override
	protected Class<SlotBase> getClassEntity()
	{
		return SlotBase.class;
	}

	@Override
	public void tick(double deltaSecond) throws IllegalEntityIdException
	{
		super.tick(deltaSecond);

		if (!slot.isEmpty()) {
			// endにむかう

			position += deltaSecond;
			if (position >= duration) {
				getEntity(idEnd).getSlotSlab().ifPresent(
					slotSlab -> slotSlab.tryPush(slot));
				position = duration;
			}

		} else {
			// beginにむかう

			position -= deltaSecond;
			if (position <= 0) {
				getEntity(idBegin).getSlotSlab().ifPresent(
					slotSlab -> slot.stack = slotSlab.tryPop(1));
				position = 0;
			}

		}

		if (slot.stack != null) {
			slot.stack.tick(game.factory, deltaSecond, ManagerEnvironment.getEnvironment(game, getPoint()));
		}

	}

	@Override
	public void drawBody(Graphics2D graphics) throws IllegalEntityIdException
	{

		Point begin = getEntity(idBegin).getPoint();
		Point end = getEntity(idEnd).getPoint();

		Color c = new Color(0x0088ff);

		// 主線
		graphics.setColor(c);
		drawMargined(graphics, begin, end, 0, 1);

		// 開始点
		{
			Stroke stroke = graphics.getStroke();
			graphics.setStroke(new BasicStroke(2));
			{
				graphics.setColor(c);
				graphics.draw(new Ellipse2D.Double(
					begin.x - 5, begin.y - 5, 5 * 2, 5 * 2));
			}
			graphics.setStroke(stroke);
		}

		// 鏃
		{
			double angle = Math.atan2(end.y - begin.y, end.x - begin.x);

			Stroke stroke = graphics.getStroke();
			graphics.setStroke(new BasicStroke(2));
			{
				graphics.setColor(c);
				graphics.draw(new Line2D.Double(
					end.x,
					end.y,
					end.x - 5 * Math.sin(angle) - 8 * Math.cos(angle),
					end.y - 8 * Math.sin(angle) + 5 * Math.cos(angle)));
				graphics.draw(new Line2D.Double(
					end.x,
					end.y,
					end.x + 5 * Math.sin(angle) - 8 * Math.cos(angle),
					end.y - 8 * Math.sin(angle) - 5 * Math.cos(angle)));
			}
			graphics.setStroke(stroke);
		}

		// プログレス
		{
			double radius = 3;

			graphics.setColor(new Color(0xdd9900));
			graphics.fill(new Ellipse2D.Double(
				begin.x + (position / duration) * (end.x - begin.x) - radius,
				begin.y + (position / duration) * (end.y - begin.y) - radius,
				radius * 2,
				radius * 2));
		}

	}

	@Override
	protected void addProperty(IDialogProperty dialogProperty)
	{
		super.addProperty(dialogProperty);

		dialogProperty.addPropertyDouble("Position", "s", () -> position, position -> {
			if (position < 0) return false;
			this.position = position;
			return true;
		});
		dialogProperty.addPropertyDouble("Duration", "s", () -> duration, duration -> {
			if (duration < 0) return false;
			this.duration = duration;
			return true;
		});
		slot.addProperty(game.factory, dialogProperty);
	}

	@Override
	protected double getMarginBegin()
	{
		return 5;
	}

	@Override
	protected double getMarginEnd()
	{
		return 0;
	}

}
