package mirrg.simulation.cart.almandine.mods.vanilla.parts;

import java.awt.Graphics2D;
import java.util.Optional;

import mirrg.simulation.cart.almandine.GameAlmandine;
import mirrg.simulation.cart.almandine.factory.IllegalEntityIdException;
import mirrg.simulation.cart.almandine.mods.vanilla.stackslab.SlotSlab;

public abstract class SlotBase extends PartRectangleBase
{

	@Deprecated
	public SlotBase()
	{
		super();
	}

	public SlotBase(GameAlmandine game, Bound bound)
	{
		super(game, bound);
	}

	public abstract Optional<SlotSlab> getSlotSlab() throws IllegalEntityIdException;

	@Override
	public void draw(Graphics2D graphics) throws IllegalEntityIdException
	{
		try {
			getSlotSlab().ifPresent(slotSlab -> slotSlab.render(graphics, this.bound.createShape()));
		} catch (ClassCastException e) {
			// getCartにて、ストリーム操作中にカートが発進すると起こる
		}
	}

}
