package mirrg.simulation.cart.almandine.mods.vanilla.parts;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;

import mirrg.simulation.cart.almandine.GameAlmandine;
import mirrg.simulation.cart.almandine.facroty.property.IDialogProperty;

public class Gauge extends PartRectangleBase
{

	@Deprecated
	public Gauge()
	{
		super();
	}

	public Gauge(GameAlmandine game, Bound bound, double capacity)
	{
		super(game, bound);
		this.capacity = capacity;
	}

	public double amount;
	public double capacity;

	@Override
	public void draw(Graphics2D graphics)
	{
		Rectangle bound = this.bound.createShape();

		// 背景
		graphics.setColor(new Color(0xffffff));
		graphics.fill(bound);

		// ゲージ
		graphics.setColor(new Color(0x00ff00));
		int h = (int) (bound.getHeight() * amount / capacity);
		graphics.fillRect(
			(int) bound.getMinX(),
			(int) bound.getMaxY() - h,
			(int) bound.getWidth(),
			h);

	}

	@Override
	protected void addProperty(IDialogProperty dialogProperty)
	{
		super.addProperty(dialogProperty);

		dialogProperty.addPropertyDouble("Amount", "?", () -> amount, amount -> {
			if (amount < 0) return false;
			this.amount = amount;
			return true;
		});
		dialogProperty.addPropertyDouble("Capacity", "?", () -> capacity, capacity -> {
			if (capacity < 0) return false;
			this.capacity = capacity;
			return true;
		});
	}

}
