package mirrg.simulation.cart.almandine.mods.vanilla.parts;

import java.awt.Point;
import java.awt.Rectangle;

/**
 * イミュータブル
 */
public class Bound
{

	private int x;
	private int y;
	private int width;
	private int height;

	@Deprecated
	public Bound()
	{

	}

	public Bound(int x, int y, int width, int height)
	{
		this.x = x;
		this.y = y;
		this.width = width;
		this.height = height;
	}

	public Bound(Rectangle rectangle)
	{
		this(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
	}

	public Bound grow(int margin)
	{
		return new Bound(x - margin, y - margin, width + margin * 2, height + margin * 2);
	}

	public int getX()
	{
		return x;
	}

	public int getY()
	{
		return y;
	}

	public int getWidth()
	{
		return width;
	}

	public int getHeight()
	{
		return height;
	}

	public Bound translate(int dx, int dy)
	{
		return new Bound(x + dx, y + dy, width, height);
	}

	public Bound resize(int width, int height)
	{
		return new Bound(x, y, width, height);
	}

	public Rectangle createShape()
	{
		return new Rectangle(x, y, width, height);
	}

	public boolean contains(int x, int y)
	{
		if (x < this.x) return false;
		if (x > this.x + width) return false;
		if (y < this.y) return false;
		if (y > this.y + height) return false;
		return true;
	}

	public boolean contains(Bound bound)
	{
		return contains(bound.x, bound.y) && contains(bound.x + bound.width, bound.y + bound.height);
	}

	public boolean contained(Rectangle rectangle)
	{
		return rectangle.contains(x, y) && rectangle.contains(x + width, y + height);
	}

	public boolean contained(Bound bound)
	{
		return bound.contains(this);
	}

	public Bound grow(int left, int top, int right, int bottom)
	{
		return new Bound(x - left, y - top, width + left + right, height + top + bottom);
	}

	public Point getCenter()
	{
		return new Point(x + width / 2, y + height / 2);
	}

}
