/*
 * Decompiled with CFR 0.152.
 */
package mirrg.swing.helium.property;

import java.util.ArrayList;
import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import mirrg.swing.helium.property.Property;
import mirrg.swing.helium.property.PropertyDouble;
import mirrg.swing.helium.property.PropertyInt;

public class ManagerProperty {
    private ArrayList<Property> properties = new ArrayList();

    public IntSupplier createPropertyInt(int defaultValue, String id, String name) {
        PropertyInt propertyInt = new PropertyInt(id, name, defaultValue);
        this.properties.add(propertyInt);
        return () -> propertyInt.value;
    }

    public DoubleSupplier createPropertyDouble(double defaultValue, String id, String name) {
        PropertyDouble propertyDouble = new PropertyDouble(id, name, defaultValue);
        this.properties.add(propertyDouble);
        return () -> propertyDouble.value;
    }

    public IntSupplier getOrCreatePropertyInt(int defaultValue, String id, String name) {
        PropertyInt property = this.properties.stream().filter(property2 -> property2.id.equals(id)).filter(property2 -> property2 instanceof PropertyInt).map(property2 -> (PropertyInt)property2).findFirst().orElse(null);
        if (property != null) {
            return () -> propertyInt.value;
        }
        return this.createPropertyInt(defaultValue, id, name);
    }

    public DoubleSupplier getOrCreatePropertyDouble(double defaultValue, String id, String name) {
        PropertyDouble property = this.properties.stream().filter(property2 -> property2.id.equals(id)).filter(property2 -> property2 instanceof PropertyDouble).map(property2 -> (PropertyDouble)property2).findFirst().orElse(null);
        if (property != null) {
            return () -> propertyDouble.value;
        }
        return this.createPropertyDouble(defaultValue, id, name);
    }

    public int getCount() {
        return this.properties.size();
    }

    public ArrayList<Property> getProperties() {
        return this.properties;
    }

    public Property getProperty(String id) {
        return this.properties.stream().filter(property -> property.id.equals(id)).findFirst().orElse(null);
    }
}

