/*
 * Decompiled with CFR 0.152.
 */
package mirrg.swing.helium.property;

import java.awt.CardLayout;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import mirrg.swing.helium.FrameMirrg;
import mirrg.swing.helium.property.ManagerProperty;
import mirrg.swing.helium.property.Property;
import mirrg.swing.helium.property.PropertyDouble;
import mirrg.swing.helium.property.PropertyInt;

public class FrameProperties
extends FrameMirrg {
    private JTable table;
    private JScrollPane scrollPane;

    public FrameProperties(ManagerProperty managerProperty) {
        super("\u30d7\u30ed\u30d1\u30c6\u30a3\u30de\u30cd\u30fc\u30b8\u30e3");
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu menu = new JMenu("\u30e1\u30cb\u30e5\u30fc(M)");
        menuBar.add(menu);
        menu.setMnemonic('M');
        JMenuItem menuItem = new JMenuItem("\u518d\u8aad\u307f\u8fbc\u307f(R)");
        menu.add(menuItem);
        menuItem.setMnemonic('R');
        menuItem.addActionListener(e -> {
            this.scrollPane.setViewportView(this.createTable(managerProperty));
            this.scrollPane.repaint();
        });
        this.scrollPane = new JScrollPane();
        this.add(this.scrollPane);
        this.scrollPane.setViewportView(this.createTable(managerProperty));
        this.setLayout(new CardLayout());
        this.prepareFrame();
        this.setDefaultCloseOperation(1);
    }

    protected JTable createTable(final ManagerProperty managerProperty) {
        final DefaultTableModel tableModel = new DefaultTableModel(0, 3){

            @Override
            public Class<?> getColumnClass(int column) {
                return String.class;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 2;
            }
        };
        tableModel.setColumnIdentifiers(new Object[]{"ID", "\u540d\u79f0", "\u5024"});
        for (Property property : managerProperty.getProperties()) {
            tableModel.addRow(new Object[]{property.id, property.name, property.getValue()});
        }
        tableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                for (int row = e.getFirstRow(); row <= e.getLastRow(); ++row) {
                    if (row == -1) continue;
                    String id = (String)tableModel.getValueAt(row, 0);
                    Property property = managerProperty.getProperty(id);
                    String string = (String)tableModel.getValueAt(row, 2);
                    if (property instanceof PropertyInt) {
                        PropertyInt propertyInt = (PropertyInt)property;
                        propertyInt.value = Integer.parseInt(string, 10);
                        continue;
                    }
                    if (!(property instanceof PropertyDouble)) continue;
                    PropertyDouble propertyDouble = (PropertyDouble)property;
                    propertyDouble.value = Double.parseDouble(string);
                }
            }
        });
        return new JTable(tableModel){};
    }
}

