/*
 * Decompiled with CFR 0.152.
 */
package mirrg.simulation.cart.almandine.gui.toolcursor;

import java.awt.event.KeyEvent;

public class ShortcutKey {
    public int keyCode;
    public boolean shift;
    public boolean control;
    public boolean alt;

    public ShortcutKey(int keyCode) {
        this.keyCode = keyCode;
    }

    public boolean match(KeyEvent e) {
        if (this.keyCode != e.getKeyCode()) {
            return false;
        }
        if (this.shift != e.isShiftDown()) {
            return false;
        }
        if (this.control != e.isControlDown()) {
            return false;
        }
        return this.alt == e.isAltDown();
    }

    public ShortcutKey shift() {
        this.shift = true;
        return this;
    }

    public ShortcutKey control() {
        this.control = true;
        return this;
    }

    public ShortcutKey alt() {
        this.alt = true;
        return this;
    }

    public String getText() {
        StringBuilder sb = new StringBuilder();
        if (this.shift) {
            sb.append("S");
        }
        if (this.control) {
            sb.append("C");
        }
        if (this.alt) {
            sb.append("A");
        }
        if (sb.length() >= 1) {
            return KeyEvent.getKeyText(this.keyCode) + "[" + sb.toString() + "]";
        }
        return KeyEvent.getKeyText(this.keyCode);
    }
}

