/*
 * Decompiled with CFR 0.152.
 */
package mirrg.simulation.cart.almandine.factory.entities.primaries;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import mirrg.simulation.cart.almandine.factory.Factory;
import mirrg.simulation.cart.almandine.factory.HFactory;
import mirrg.simulation.cart.almandine.factory.IllegalEntityIdException;
import mirrg.simulation.cart.almandine.factory.entities.Entity;
import mirrg.simulation.cart.almandine.factory.entities.Primary;
import mirrg.simulation.cart.almandine.gui.property.IDialogProperty;

public abstract class PrimaryConnection<E extends Entity>
extends Primary {
    public int idBegin;
    public int idEnd;

    @Deprecated
    public PrimaryConnection() {
    }

    public PrimaryConnection(Factory factory, E begin, E end) {
        super(factory);
        this.idBegin = ((Entity)begin).getId();
        this.idEnd = ((Entity)end).getId();
    }

    protected E getEntity(Factory factory, int id) throws IllegalEntityIdException {
        Entity entity = factory.getEntity(id).orElse(null);
        if (entity == null) {
            throw new IllegalEntityIdException("id=" + id);
        }
        E entity2 = this.castEntity(entity);
        if (entity2 == null) {
            throw new IllegalEntityIdException("id=" + id);
        }
        return entity2;
    }

    public double getAngle(Factory factory) throws IllegalEntityIdException {
        Point pointBegin = ((Entity)this.getEntity(factory, this.idBegin)).getPoint(factory);
        Point pointEnd = ((Entity)this.getEntity(factory, this.idEnd)).getPoint(factory);
        return Math.atan2(pointEnd.y - pointBegin.y, pointEnd.x - pointBegin.x);
    }

    protected abstract E castEntity(Entity var1);

    @Override
    public boolean isHover(Factory factory, int x, int y) throws IllegalEntityIdException {
        Point pointBegin = ((Entity)this.getEntity(factory, this.idBegin)).getPoint(factory);
        Point pointEnd = ((Entity)this.getEntity(factory, this.idEnd)).getPoint(factory);
        return new Line2D.Double(pointBegin, pointEnd).ptSegDist(x, y) < 5.0;
    }

    @Override
    public void renderHover(Factory factory, Graphics2D graphics) throws IllegalEntityIdException {
        Point pointBegin = ((Entity)this.getEntity(factory, this.idBegin)).getPoint(factory);
        Point pointEnd = ((Entity)this.getEntity(factory, this.idEnd)).getPoint(factory);
        Stroke stroke = graphics.getStroke();
        graphics.setStroke(new BasicStroke(2.0f));
        graphics.setColor(new Color(8125570));
        HFactory.drawLine(graphics, pointBegin, pointEnd, 0.0, 4.5, 0.0, 1.0);
        graphics.setStroke(stroke);
    }

    @Override
    public void render(Factory factory, Graphics2D graphics) throws IllegalEntityIdException {
        this.renderBody(factory, graphics);
        if (this.selected) {
            this.renderSelectMarker(factory, graphics);
        }
    }

    protected abstract void renderBody(Factory var1, Graphics2D var2) throws IllegalEntityIdException;

    protected void renderSelectMarker(Factory factory, Graphics2D graphics) throws IllegalEntityIdException {
        Point pointBegin = ((Entity)this.getEntity(factory, this.idBegin)).getPoint(factory);
        Point pointEnd = ((Entity)this.getEntity(factory, this.idEnd)).getPoint(factory);
        Stroke stroke = graphics.getStroke();
        graphics.setStroke(new BasicStroke(3.0f));
        graphics.setColor(new Color(255, 128, 0));
        HFactory.drawLine(graphics, pointBegin, pointEnd, 0.0, 0.0, 0.0, 1.0);
        graphics.setStroke(stroke);
    }

    @Override
    protected void addProperty(Factory factory, IDialogProperty dialogProperty) {
        super.addProperty(factory, dialogProperty);
        dialogProperty.addPropertyInt("IdBegin", "id", () -> this.idBegin, idBegin -> {
            Entity entity = factory.getEntity(idBegin).orElse(null);
            if (entity == null) {
                return false;
            }
            E entity2 = this.castEntity(entity);
            if (entity2 == null) {
                return false;
            }
            this.idBegin = idBegin;
            return true;
        });
        dialogProperty.addPropertyInt("IdEnd", "id", () -> this.idEnd, idEnd -> {
            Entity entity = factory.getEntity(idEnd).orElse(null);
            if (entity == null) {
                return false;
            }
            E entity2 = this.castEntity(entity);
            if (entity2 == null) {
                return false;
            }
            this.idEnd = idEnd;
            return true;
        });
    }

    @Override
    public Point getPoint(Factory factory) throws IllegalEntityIdException {
        Point pointBegin = ((Entity)this.getEntity(factory, this.idBegin)).getPoint(factory);
        Point pointEnd = ((Entity)this.getEntity(factory, this.idEnd)).getPoint(factory);
        return new Point((pointBegin.x + pointEnd.x) / 2, (pointBegin.y + pointEnd.y) / 2);
    }

    public Point2D.Double getPoint(Factory factory, double position) throws IllegalEntityIdException {
        Point2D.Double[] pointMargined = this.getPointMargined(factory);
        Point2D.Double begin = pointMargined[0];
        Point2D.Double end = pointMargined[1];
        return new Point2D.Double(begin.x + (end.x - begin.x) * position, begin.y + (end.y - begin.y) * position);
    }

    public double getPosition(Factory factory, double x, double y) throws IllegalEntityIdException {
        Point2D.Double[] pointMargined = this.getPointMargined(factory);
        double x2 = pointMargined[1].x - pointMargined[0].x;
        double y2 = pointMargined[1].y - pointMargined[0].y;
        double anglePoint = Math.atan2(y -= pointMargined[0].y, x -= pointMargined[0].x);
        double angleConnection = Math.atan2(y2, x2);
        double lengthPoint = Math.sqrt(x * x + y * y);
        double lengthConnection = Math.sqrt(x2 * x2 + y2 * y2);
        double position = Math.cos(anglePoint -= angleConnection) * lengthPoint / lengthConnection;
        if (position <= 0.0) {
            return 0.0;
        }
        if (position >= 1.0) {
            return 1.0;
        }
        return position;
    }

    protected void drawMargined(Graphics2D graphics, Factory factory, Point begin, Point end, double ratioBegin, double ratioEnd) throws IllegalEntityIdException {
        HFactory.drawLine(graphics, begin, end, this.getMarginBegin(factory), this.getMarginEnd(factory), 0.0, 1.0);
    }

    protected abstract double getMarginBegin(Factory var1) throws IllegalEntityIdException;

    protected abstract double getMarginEnd(Factory var1) throws IllegalEntityIdException;

    protected Point2D.Double[] getPointMargined(Factory factory) throws IllegalEntityIdException {
        Point pointBegin = ((Entity)this.getEntity(factory, this.idBegin)).getPoint(factory);
        Point pointEnd = ((Entity)this.getEntity(factory, this.idEnd)).getPoint(factory);
        double length = pointBegin.distance(pointEnd);
        Point pointDistance = new Point(pointEnd.x - pointBegin.x, pointEnd.y - pointBegin.y);
        double marginBegin = this.getMarginBegin(factory);
        double marginEnd = this.getMarginEnd(factory);
        double ratioBeginMargined = marginBegin / length;
        double ratioEndMargined = (length - marginEnd) / length;
        Point2D.Double pointBeginMargined = new Point2D.Double((double)pointBegin.x + (double)pointDistance.x * ratioBeginMargined, (double)pointBegin.y + (double)pointDistance.y * ratioBeginMargined);
        Point2D.Double pointEndMargined = new Point2D.Double((double)pointBegin.x + (double)pointDistance.x * ratioEndMargined, (double)pointBegin.y + (double)pointDistance.y * ratioEndMargined);
        return new Point2D.Double[]{pointBeginMargined, pointEndMargined};
    }

    @Override
    public void tick(Factory factory, double deltaSecond) throws IllegalEntityIdException {
        ((Entity)this.getEntity(factory, this.idBegin)).getPoint(factory);
        ((Entity)this.getEntity(factory, this.idEnd)).getPoint(factory);
    }
}

