/*
 * (c) Copyright Sysdeo SA 2001, 2002.
 * All Rights Reserved.
 */

package com.sysdeo.eclipse.tomcat.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

import com.sysdeo.eclipse.tomcat.TomcatLauncherPlugin;

/**
 * StartActionDelegate
 *
 */
public class StartActionDelegate extends AbstractHandler implements IWorkbenchWindowActionDelegate {

	/** IWorkbenchWindow */
	private IWorkbenchWindow window;

	/**
	 * @return the window
	 */
	protected IWorkbenchWindow getWindow() {
		return this.window;
	}

	/**
	 * @see IWorkbenchWindowActionDelegate#dispose()
	 */
	@Override
	public void dispose() {
		return;
	}

	/**
	 * @see IWorkbenchWindowActionDelegate#init(IWorkbenchWindow)
	 */
	@Override
	public void init(final IWorkbenchWindow ww) {
		this.window = ww;
	}

	/**
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	@Override
	public void run(final IAction action) {
		start();
	}

	/**
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(
	 * org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
	 */
	@Override
	public void selectionChanged(final IAction action, final ISelection selection) {
		return;
	}

	/**
	 * @see org.eclipse.core.commands.IHandler#execute(org.eclipse.core.commands.ExecutionEvent)
	 */
	@Override
	public Object execute(final ExecutionEvent event) throws ExecutionException {
		start();
		return null;
	}

	/**
	 * start
	 */
	private static void start() {
		if (TomcatLauncherPlugin.checkTomcatSettingsAndWarn()) {
			try {
				TomcatLauncherPlugin.getTomcatBootstrap().start();
			} catch (final CoreException ex) {
				String msg = TomcatLauncherPlugin.getResourceString("msg.start.failed");
				TomcatLauncherPlugin.log(msg + "/n");
				TomcatLauncherPlugin.log(ex);
			}
		}
	}
}
