function setAid(formId, aid) {
	if (canSubmit()) {
		if (typeof formId !== "undefined" && formId !== null && formId !== "") {
			gSubmitTimer.setSubmitTimer();

			var fm = document.getElementById(formId);
			if (typeof aid !== "undefined" && aid !== null && aid !== "") {
				var ele = document.getElementById("aid");
				if (ele === null) {
					ele = document.createElement('input');
					ele.setAttribute("id", "aid");
					ele.setAttribute("name", "AID");
					ele.setAttribute("type", "hidden");
					fm.appendChild(ele);
				}
				ele.value = aid;
			}
			return true;
		}
	}
	return false;
}

function trick(method) {
	if ("POST" === method) {
		if (0 <= navigator.userAgent.indexOf('Safari')) {
			if (window.location.toString() === document.referrer.toString()) {
				window.history.back();
			}
		}
	}
}

function setAttribute(id, attribute, val) {
	var item = document.getElementById(id);
	if (item !== null) {
		var attr = item.getAttributeNode(attribute);
		if (attr !== null && val !== null) {
			if (id.indexOf("${") < 0 && val.indexOf("${") < 0) {
				attr.value = val;
			}
		}
	}
}

function setCheckByItem(item, bool) {
	if (typeof item !== "undefined" && item !== null) {
		var setCheck = function(item, bool) {
			if (!item.disabled) {
				if (item.type === "checkbox" || item.type === "radio") {
					item.checked = bool;
				}
			}
		};

		if (item.length) {
			for (var i = 0, len = item.length; i < len; i += 1) {
				setCheck(item[i], bool);
			}
		} else {
			setCheck(item, bool);
		}
	}
}

function getRadioValueByItem(item) {
	if (typeof item !== "undefined" && item !== null) {
		if (item.length) {
			for (var i = 0, len = item.length; i < len; i += 1) {
				if (item[i].type === "radio" && item[i].checked) {
					return item[i].value;
				}
			}
		} else {
			if (item.type === "radio" && item.checked) {
				return item.value;
			}
		}
	}
	return "";
}

function getCheckValueArrayByItem(item) {
	var ret = [];
	if (typeof item !== "undefined" && item !== null) {
		var getCheckValue = function(item, ret, loc) {
			if (item.type === "checkbox" && item.checked) {
				ret[loc] = item.value;
				return (loc + 1);
			}
			return loc;
		}

		if (item.length) {
			var loc = 0;
			for (var i = 0, len = item.length; i < len; i += 1) {
				loc = getCheckValue(item[i], ret, loc);
			}
		} else {
			getCheckValue(item, ret, 0);
		}
	}
	return ret;
}

resizable: function(table, fix) {
	var resetSlider = function(tbl) {
		var id = tbl.attr('id');
		tbl.find('tr:first th').each(function(idx){
			var th = $(this);
			var pos = th.offset().left + th.outerWidth();
			$('#' + id + '_' + (idx + 1)).css({left: pos + 'px', height: tbl.height() + 'px'});
		});
	};
	var resetTable = function(tbl, diff, idx) {
		var span = function(item) {
			if ($(item).attr('colspan')) {
				return parseInt($(item).attr('colspan'));
			}
			return 1;
		};

		var id = tbl.attr('id');
		var th = $('#' + id + ' tr th').get(idx);
		if (!$.data(th, 'width')) {$.data(th, 'width', th.offsetWidth);}

		var begin = 0, end = 0;
		$('#' + id + ' tr th:lt(' + idx + ')').each(function(){
			begin = begin + span(this);
		});
		end = begin + span(th);

		$('#' + id + ' tr').each(function(){
			var i = 0;
			$(this).find('td').each(function(){
				if (begin <= i && i < end) {
					if (!$(this).data('width')) {
						$(this).data('width', Math.round($(this).width()));
					}
				} else if (end <= i) {
					return false;
				}
				i = i + span(this);
			});
		});

		var ow = th.offsetWidth + diff;
		if (ow < $.data(th, 'width')) {ow = $.data(th, 'width');}
		$(th).width(ow);

		$('#' + id + ' tr').each(function(){
			var i = 0;
			$(this).find('td').each(function(){
				if (begin <= i && i < end) {
					var w = ow;
					if (end - begin !== span(this)) {
						w = Math.round(ow * $(this).data('width') / $.data(th, 'width'));
					}
					if (w < $(this).data('width')) {w = $(this).data('width');}
					$(this).width(w);
				} else if (end <= i) {
					return false;
				}
				i = i + span(this);
			});
		});

		resetSlider(tbl);
	};

	var tid = table.attr('id');
	for (var i = 1, cols = table.find('tr:first th').size(); i <= cols; i++) {
		$('#' + tid + '_' + i).remove();
		if (fix && i <= fix) {
			$('<div style="position:absolute;z-index:5;" id="' + tid + '_' + i + '"></div>').
				insertBefore(table).data('tid', tid).data('idx', i);
		} else {
			$('<div class="draghandle" id="' + tid + '_' + i + '"></div>').
					insertBefore(table).data('tid', tid).data('idx', i).draggable(
				{
					axis: 'x',
					start: function() {
						var id = $(this).data('tid');
						$(this).toggleClass('dragged');
						$(this).height($('#' + id).height());
					},
					stop: function(ev, ui) {
						var id = $(this).data('tid');
						$(this).toggleClass('dragged');
						var pos = $(this).data('draggable').originalPosition.left;
						resetTable($('#' + id), ui.position.left - pos, $(this).data('idx') - 1)
					}
				}
			);
		}
	}
	resetSlider(table);
}
