package project.auth.jaas;

import java.io.Serializable;
import java.security.Principal;

/**
 * ユーザプリンシパルクラス
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public final class LogonPrincipal implements Principal, Serializable {
	/** serialVersionUID */
	private static final long serialVersionUID = -4543130301122862178L;

	/** ユーザ名 */
	private final String nm;

	/**
	 * コンストラクタ
	 *
	 * @param name ユーザ名
	 */
	public LogonPrincipal(final String name) {
		if (name == null) {
			throw new NullPointerException();
		}
		this.nm = name;
	}

	/**
	 * ユーザ名を返す。
	 *
	 * @return ユーザ名
	 */
	@Override
	public String getName() {
		return this.nm;
	}

	/**
	 * オブジェクトが等しいか判断する。
	 *
	 * @param o プリンシパルオブジェクト
	 * @return オブジェクトが等しい場合 true
	 */
	@Override
	public boolean equals(final Object o) {
		return (o != null && this == o)
			|| (LogonPrincipal.class.isInstance(o)
					&& this.getName().equals(LogonPrincipal.class.cast(o).getName()));
	}

	/**
	 * ハッシュコードを返す。
	 *
	 * @return ハッシュコード
	 */
	@Override
	public int hashCode() {
		return this.nm.hashCode();
	}
}
