package project.common;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.JUnitCore;

public class TestSringUtil {

	/**
	 * main
	 * @param args arguments
	 */
	public static void main(final String... args) {
		JUnitCore.main(TestCsvUtil.class.getName());
	}


	@Test
	public void 先頭ゼロサプレス() {
		Assert.assertEquals("1", StringUtil.suppressZero("0001"));
	}

	@Test
	public void 先頭ゼロサプレス小数点あり() {
		Assert.assertEquals("1.123", StringUtil.suppressZero("0001.123"));
	}


	@Test
	public void 左トリム() {
		Assert.assertEquals("1", StringUtil.trimLeft("0001", '0'));
	}


	@Test
	public void 右トリム() {
		Assert.assertEquals("000", StringUtil.trimRight("0001", '1'));
	}


	@Test
	public void 指定文字列挿入空文字() {
		Assert.assertEquals("", StringUtil.infix("", "-", 1, 2));
	}

	@Test
	public void 指定文字列挿入一文字() {
		Assert.assertEquals("A", StringUtil.infix("A", "-", 1, 2));
	}

	@Test
	public void 指定文字列挿入２文字() {
		Assert.assertEquals("A-B", StringUtil.infix("AB", "-", 1));
	}

	@Test
	public void 指定文字列挿入２文字右から() {
		Assert.assertEquals("A-B", StringUtil.infix("AB", "-", -1));
	}

	@Test
	public void 指定文字列挿入７文字左右から７以下指定() {
		Assert.assertEquals("AB-C-D-EF-G", StringUtil.infix("ABCDEFG", "-", -1, 2, 3, -3));
	}

	@Test
	public void 指定文字列挿入７文字左右から７以上指定あり時() {
		Assert.assertEquals("AB-CDEF-G", StringUtil.infix("ABCDEFG", "-", -1, 2, 13, -9));
	}
}
