package online.model;

import java.io.Serializable;
import java.lang.reflect.Array;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.JUnitCore;

public class TestUniMap {

	/**
	 * main
	 * @param args arguments
	 */
	public static void main(final String... args) {
		JUnitCore.main(TestUniMap.class.getName());
	}

	@Test
	public void testArraySize1() {
		UniMap<String, Serializable> um = new UniMap<>();
		um.put("aaaaa", null, String.class);
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("aaaaa")));
		Assert.assertEquals("{aaaaa=null}", um.toString());
		Assert.assertNull(um.get("aaaaa"));
	}

	@Test
	public void testArraySize2() {
		UniMap<String, Serializable> um = new UniMap<>();
		um.put("aaaaa", null, String[].class);
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("aaaaa")));
		Assert.assertEquals("{aaaaa=null}", um.toString());
		Assert.assertNull(um.get("aaaaa"));
	}

	@Test
	public void testArraySize3() {
		UniMap<String, Serializable> um = new UniMap<>();
		um.put("aaaaa", new String[]{null});
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("aaaaa")));
		Assert.assertEquals("{aaaaa=[null]}", um.toString());
		Assert.assertNull(Array.get(um.get("aaaaa"), 0));
	}

	@Test
	public void testArraySize4() {
		UniMap<String, Serializable> um = new UniMap<>();
		um.put("aaaaa", new String[][]{new String[]{null}});
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("aaaaa")));
		Assert.assertEquals("{aaaaa=[[null]]}", um.toString());
		Assert.assertNull(Array.get(Array.get(um.get("aaaaa"), 0), 0));
	}

	@Test
	public void testArraySize5() {
		UniMap<String, Serializable> um = new UniMap<>();
		um.put("aaaaa", new String[0]);
		Assert.assertEquals(0, um.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("aaaaa")));
		Assert.assertEquals("{aaaaa=[]}", um.toString());
		Assert.assertEquals(0, Array.getLength(um.get("aaaaa")));
	}

	@Test
	public void testArraySize6() {
		UniMap<String, Serializable> um = new UniMap<>();
		um.put("aaaaa", new String[0][0]);
		Assert.assertEquals(0, um.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("aaaaa")));
		Assert.assertEquals("{aaaaa=[[]]}", um.toString());
		Assert.assertEquals(String[][].class, um.get("aaaaa").getClass());
	}

	@Test
	public void testArraySize7() {
		UniMap<String, Serializable> um = new UniMap<>();
		um.putRaw("aaaaa", new String[0]);
		Assert.assertEquals(0, um.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("aaaaa")));
		Assert.assertEquals("{aaaaa=null}", um.toString());
		Assert.assertNull(um.get("aaaaa"));
	}

	@Test
	public void testArraySize8() {
		UniMap<String, Serializable> um = new UniMap<>();
		um.putRaw("aaaaa", new String[0][0]);
		Assert.assertEquals(0, um.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("aaaaa")));
		Assert.assertEquals("{aaaaa=null}", um.toString());
		Assert.assertNull(um.get("aaaaa"));
	}

	@Test
	public void testArraySize9() {
		UniMap<String, Serializable> um = new UniMap<>();
		um.putRaw("aaaaa", new String[1][0]);
		Assert.assertEquals(0, um.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("aaaaa")));
		Assert.assertEquals("{aaaaa=[]}", um.toString());
		Assert.assertEquals(0, Array.getLength(um.get("aaaaa")));
	}


	@Test
	public void testToArray1() {
		UniMap<String, Serializable> um = new UniMap<>();
		um.put("aaaaa", null);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("aaaaa")));
		Assert.assertEquals(1, um.getArraySize("aaaaa"));

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.toArrayValue("aaaaa")));

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("aaaaa")));
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
	}

	@Test
	public void testToArray2() {
		UniMap<String, Serializable> um = new UniMap<>();
		um.put("aaaaa", null, String[].class);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("aaaaa")));
		Assert.assertEquals(1, um.getArraySize("aaaaa"));

		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.toArrayValue("aaaaa")));

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("aaaaa")));
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
	}

	@Test
	public void testToArray3() {
		UniMap<String, Serializable> um = new UniMap<>();
		um.put("aaaaa", new String[]{null, null});
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("aaaaa")));
		Assert.assertEquals(2, um.getArraySize("aaaaa"));

		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.toArrayValue("aaaaa")));

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("aaaaa")));
		Assert.assertEquals(2, um.getArraySize("aaaaa"));
	}

}
