package project.web.processor;

import online.struts.action.UniForm;
import online.struts.chain.command.ActionRequest;
import online.struts.chain.command.ActionRequest.CommandRequest;
import online.struts.mapping.RequestMapping;

import org.apache.commons.chain2.Processing;
import org.apache.struts.chain.commands.ActionCommandBase;
import org.apache.struts.chain.contexts.ActionContext;
import org.apache.struts.chain.contexts.ServletActionContext;

/**
 * パターンリスト設定
 * @author Tadashi Nakayama
 */
public final class PatternListProcessor extends ActionCommandBase implements CommandRequest {

	/**
	 * @see org.apache.struts.chain.commands.ActionCommandBase
	 * #execute(org.apache.struts.chain.contexts.ActionContext)
	 */
	@Override
	public Processing execute(final ActionContext<String, Object> context) {
		return ActionRequest.execute(context, this);
	}

	/**
	 * @see online.struts.chain.command.ActionRequest.CommandRequest
	 * #command(org.apache.struts.chain.contexts.ServletActionContext,
	 * online.struts.mapping.RequestMapping, online.struts.action.UniForm)
	 */
	@Override
	public Processing command(final ServletActionContext sac,
					final RequestMapping mapping, final UniForm uf) {
		if (!ActionRequest.isException(sac) && !sac.getResponse().isCommitted()
						&& sac.getForwardConfig() != null) {
			// 一覧設定
			PatternSearchProcessor.setPatternList(sac, uf);
		}
		return Processing.CONTINUE;
	}
}

