package project.web.generic.csv;

import online.struts.action.UniForm;
import project.common.StringUtil;
import project.svc.generic.QueryService;
import project.svc.generic.UpdateService;
import project.svc.generic.csv.extract.QueryBuilder;
import project.web.InstanceFactory;

import common.db.ExclusiveException;

import core.exception.ThrowableUtil;

/**
 * CSVアクションユーティリティクラス
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
final class CsvActionUtil {

	/** 基本クエリ項目 */
	public static final String QUERY_FROM = "QueryFrom";
	/** 基本条件項目 */
	public static final String QUERY_WHERE = "QueryWhere";
	/** 出力項目値項目 */
	public static final String ITEM_VALUE = "ItemValue";
	/** 出力項目名項目 */
	public static final String ITEM_LABEL = "ItemLabel";
	/** 集約項目 */
	public static final String GROUP_FLG = "GroupFlg";
	/** 集計項目 */
	public static final String AGGREGATION_KBN = "AggregationKbn";
	/** 順序項目 */
	public static final String ORDER_SORT = "OrderSort";
	/** 順序区分項目 */
	public static final String ORDER_KBN = "OrderKbn";
	/** 出力項目 */
	public static final String OUTPUT_FLG = "OutputFlg";
	/** 条件数項目 */
	public static final String CONDITION_COLUMN = "ConditionColumn";
	/** 演算項目 */
	public static final String OPERATOR = "Operator";
	/** 条件値項目 */
	public static final String CONDITION = "Condition";
	/** 条件項目名項目 */
	public static final String ITEM_NAME = "ItemName";

	/**
	 * コンストラクタ
	 */
	private CsvActionUtil() {
		throw new AssertionError();
	}

	/**
	 * 選択処理
	 * @param query クエリ
	 * @param model 汎用モデル
	 * @return 選択結果
	 */
	public static boolean select(final String query, final UniForm model) {
		QueryService ql = InstanceFactory.create(QueryService.class, model);
		ql.setQueryFile(query);
		boolean ret = ql.search();
		model.putAll(ql.getResultModel());
		return ret;
	}

	/**
	 * 更新処理
	 * @param query クエリ
	 * @param model 汎用モデル
	 * @return 処理件数
	 */
	public static int update(final String query, final UniForm model) {
		UpdateService ql = InstanceFactory.create(UpdateService.class, model);
		ql.setQueryFile(query);
		try {
			return ql.update();
		} catch (final ExclusiveException ex) {
			ThrowableUtil.warn(ex);
			return 0;
		}
	}

	/**
	 * 詳細項目更新処理
	 * @param query クエリ
	 * @param model 汎用モデル
	 * @param item サイズ判定項目名
	 */
	public static void updateArray(final String query, final UniForm model, final String item) {
		String no = "DtlNo";
		model.setValue(no, StringUtil.sequence(model.getArraySize(item), 1));

		UpdateService ql = InstanceFactory.create(UpdateService.class, model);
		ql.setQueryFile(query);
		try {
			ql.updateArray(no);
		} catch (final ExclusiveException ex) {
			ThrowableUtil.warn(ex);
			return;
		}
	}

	/**
	 * スキーマ名取得
	 * @param model 汎用モデル
	 * @return スキーマ名
	 */
	public static String getSchema(final UniForm model) {
		if (select("project.svc.generic.csv.extract.SelectQuery", model)) {
			return model.getString("SchemaName");
		}
		return null;
	}

	/**
	 * クエリビルダ取得
	 * @param model 汎用モデル
	 * @return クエリビルダ
	 */
	public static QueryBuilder getQueryBuilder(final UniForm model) {
		QueryBuilder qb = new QueryBuilder(model.getString(QUERY_FROM),
						model.getString(QUERY_WHERE), model.getStringArray(ITEM_VALUE),
						model.getStringArray(ITEM_LABEL));
		qb.setGroup(model.getStringArray(GROUP_FLG));
		qb.setAggregation(model.getStringArray(AGGREGATION_KBN));
		qb.setOrderSort(model.getNumberArray(ORDER_SORT));
		qb.setOrderKbn(model.getStringArray(ORDER_KBN));
		qb.setColumnOutput(model.getStringArray(OUTPUT_FLG));
		qb.setCondition(getColumnSize(model), model.getStringArray(OPERATOR),
						model.getStringArray(CONDITION), model.getStringArray(ITEM_NAME));
		return qb;
	}

	/**
	 * カラムサイズ取得
	 * @param model 汎用モデル
	 * @return カラムサイズ
	 */
	private static int getColumnSize(final UniForm model) {
		if (model.hasValue(CONDITION_COLUMN)) {
			return model.getNumber(CONDITION_COLUMN).intValue();
		}
		return model.getArraySize(ITEM_NAME);
	}
}
