package project.view.tag;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.jsp.JspException;

import online.view.ViewUtil;
import online.view.tag.BaseTag;
import project.common.master.AppConfig;
import project.view.LabelValue;
import core.config.Factory;

/**
 * APConfigタグ
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public final class ConfigTag extends BaseTag {
	/** serialVersionUID */
	private static final long serialVersionUID = -6920639287146864153L;

	/** 変数用変数 */
	private String var = null;
	/** 機能ID */
	private String fid = null;
	/** 環境種別 */
	private String env = null;
	/** 詳細種別 */
	private String dtl = null;

	/**
	 * リリース処理
	 */
	@Override
	public void release() {
		this.var = null;
		this.fid = null;
		this.env = null;
		this.dtl = null;
	}

	/**
	 * 変数設定
	 *
	 * @param val 保存変数名文字列
	 */
	public void setVar(final String val) {
		this.var = val;
	}

	/**
	 * 機能ID設定
	 *
	 * @param val 機能ID
	 */
	public void setFid(final String val) {
		this.fid = val;
	}

	/**
	 * 環境種別設定
	 *
	 * @param val 環境種別
	 */
	public void setEnv(final String val) {
		this.env = val;
	}

	/**
	 * 詳細種別設定
	 *
	 * @param val 詳細種別
	 */
	public void setDtl(final String val) {
		this.dtl = val;
	}

	/**
	 * @see javax.servlet.jsp.tagext.TagSupport#doStartTag()
	 */
	@Override
	public int doStartTag() throws JspException {
		try {
			doTag();
			return SKIP_BODY;
		} finally {
			release();
		}
	}

	/**
	 * タグ処理
	 */
	public void doTag() {
		// アトリビュートクリア
		if (this.var != null) {
			this.pageContext.removeAttribute(this.var);
		}

		AppConfig ac = Factory.create(AppConfig.class);
		if (this.dtl != null) {
			String val = ac.getValue(this.fid, this.env, this.dtl);
			super.output(this.var,
							ViewUtil.sanitize(val, ViewUtil.getCharset(super.getResponse()), true));
		} else if (this.var != null) {
			this.pageContext.setAttribute(this.var,
							createList(ac.getValueList(this.fid, this.env),
								ac.getDetailList(this.fid, this.env)));
		}
	}

	/**
	 * LabelValueリスト作成
	 * @param ll ラベルリスト
	 * @param vl バリューリスト
	 * @return LabelValueリスト
	 */
	private List<LabelValue> createList(final List<String> ll, final List<String> vl) {
		Charset cs = ViewUtil.getCharset(super.getResponse());
		List<LabelValue> ret = new ArrayList<>();
		for (int i = 0; i < ll.size(); i++) {
			String lbl = ViewUtil.sanitize(ll.get(i), cs, true);
			String val = ViewUtil.sanitize(vl.get(i), cs, true);
			ret.add(new LabelValue(lbl, val));
		}
		return ret;
	}
}
