package online.struts.chain.processor;

import org.apache.commons.chain2.Processing;
import org.apache.struts.action.Action;
import org.apache.struts.chain.commands.servlet.CreateAction;
import org.apache.struts.chain.contexts.ActionContext;
import org.apache.struts.config.ActionConfig;

import online.struts.BeanUtil;
import online.struts.mapping.RequestMapping;

/**
 * アクション作成プロセッサ
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public final class CreateActionProcessor extends CreateAction {

	/**
	 * @see org.apache.struts.chain.commands.AbstractCreateAction
	 * \#execute(org.apache.struts.chain.contexts.ActionContext)
	 */
	@Override
	public Processing execute(final ActionContext<String, Object> actionCtx) {
		if (actionCtx.getForwardConfig() == null) {
			return super.execute(actionCtx);
		}
		return Processing.CONTINUE;
	}

	/**
	 * @see org.apache.struts.chain.commands.AbstractCreateAction
	 * #getAction(org.apache.struts.chain.contexts.ActionContext,
	 * java.lang.String, org.apache.struts.config.ActionConfig)
	 */
	@Override
	protected Action getAction(final ActionContext<String, Object> context, final String type,
			final ActionConfig actionConfig) {
		Action action = createAction(context, type);
		if (RequestMapping.class.isInstance(actionConfig)) {
			RequestMapping rm = RequestMapping.class.cast(actionConfig);
			BeanUtil.setPropertiesTo(action, rm.getPropertiesMap());
		}
		return action;
	}
}
