package online.struts.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import online.model.ModelUtil;
import online.struts.mapping.RequestMapping;

import org.apache.logging.log4j.LogManager;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/**
 * Performアクション
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public abstract class PerformAction implements Action {

	/** ビュー */
	public static final String ID_VIEW = "VIEW";
	/** ID OK */
	public static final String ID_OK = "OK";
	/** ID NG */
	public static final String ID_NG = "NG";

	/**
	 * @see org.apache.struts.action.Action
	 * #execute(org.apache.struts.action.ActionMapping,
	 * org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest,
	 * javax.servlet.http.HttpServletResponse)
	 */
	@Override
	public final ActionForward execute(final ActionMapping mapping, final ActionForm form,
			final HttpServletRequest request, final HttpServletResponse response) {
		if (!RequestMapping.class.isInstance(mapping)) {
			LogManager.getLogger().error(mapping);
			throw new IllegalArgumentException();
		}
		RequestMapping rm = RequestMapping.class.cast(mapping);

		// フォームキャスト
		if (!UniForm.class.isInstance(form)) {
			LogManager.getLogger().error(form);
			throw new IllegalArgumentException();
		}
		UniForm uf = UniForm.class.cast(form);

		// アクション呼出
		uf.remove(ModelUtil.TAG_RETURN);
		String ret = perform(rm, uf, request, response);
		if (!uf.containsKey(ModelUtil.TAG_RETURN)) {
			uf.setValue(ModelUtil.TAG_RETURN, ret);
		}
		ActionForward af = mapping.findForward(ret);
		return af != null ? af : new ActionForward(ret, null, false);
	}

	/**
	 * 従処理
	 *
	 * @param mapping ActionMappingオブジェクト
	 * @param uf 汎用フォーム
	 * @param request HttpServletRequestオブジェクト
	 * @param response HttpServletResponseオブジェクト
	 * @return 処理結果
	 */
	public abstract String perform(RequestMapping mapping, UniForm uf,
			HttpServletRequest request, HttpServletResponse response);
}
