package project.check.existence;

import java.util.Objects;
import java.util.Optional;

import core.util.ArrayUtil;
import core.util.bean.Pair;
import online.model.ModelUtil;
import project.check.BaseCheck;
import project.master.MsgUtil;

/**
 * 必須入力チェック
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public final class MustCheck extends BaseCheck {

	/** メッセージID */
	private final String mid;
	/** メッセージパラメータ */
	private final String[] prm;

	/**
	 * コンストラクタ
	 */
	public MustCheck() {
		this.mid = null;
		this.prm = null;
	}

	/**
	 * コンストラクタ
	 *
	 * @param msgId メッセージID
	 * @param param メッセージパラメータ
	 */
	public MustCheck(final String msgId, final String... param) {
		this.mid = msgId;
		this.prm = ArrayUtil.copyOf(param);
	}

	/**
	 * @see online.context.check.ItemCheck#check(java.lang.String...)
	 */
	@Override
	public void check(final String... items) {
		Optional<Pair<String, Integer>> check = Optional.empty();
		for (final String item : items) {
			String[] val = super.getArrayParameter(item);
			if (val == null || val.length == 0) {
				if (!MsgUtil.hasItemMessage(super.getUniModel(), item)) {
					super.addTopMessage(this.mid, this.prm);
					MsgUtil.putMessage(super.getUniModel(), item, this.mid, this.prm);
				}
				check = Optional.of(check.orElse(new Pair<>(item, Integer.valueOf(0))));
				continue;
			}

			for (int j = 0; j < val.length; j++) {
				if (!super.isTarget(j)) {
					val[j] = ModelUtil.getValueAsString(super.getUniModel(), item, j);
				} else if (Objects.toString(val[j], "").isEmpty()) {
					super.setMessage(item, j, this.mid, this.prm);
					check = Optional.of(check.orElse(new Pair<>(item, Integer.valueOf(j))));
				}
			}
		}

		check.ifPresent(this::throwKeepCheckException);
	}
}
