package project.check.attribute;

import java.util.Optional;
import java.util.stream.Stream;

import core.util.ArrayUtil;
import core.util.NumberUtil;
import core.util.bean.Pair;
import online.context.check.ItemConvert;
import online.model.ModelUtil;
import project.check.BaseCheck;
import project.common.CheckUtil;

/**
 * 拡張数値チェック
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public final class LongNumeralCheck extends BaseCheck implements ItemConvert<Long> {

	/** メッセージID */
	private final String mid;
	/** メッセージパラメータ */
	private final String[] prm;

	/**
	 * コンストラクタ
	 */
	public LongNumeralCheck() {
		this.mid = null;
		this.prm = null;
	}

	/**
	 * コンストラクタ
	 *
	 * @param msgId メッセージID
	 * @param param メッセージパラメータ
	 */
	public LongNumeralCheck(final String msgId, final String... param) {
		this.mid = msgId;
		this.prm = ArrayUtil.copyOf(param);
	}

	/**
	 * @see online.context.check.ItemCheck#check(java.lang.String[])
	 */
	@Override
	public void check(final String... items) {
		Optional<Pair<String, Integer>> check = Optional.empty();
		for (final String item : items) {
			String[] val = super.getArrayParameter(item);
			for (int j = 0; val != null && j < val.length; j++) {
				if (!super.isTarget(j)) {
					val[j] = ModelUtil.getValueAsString(super.getUniModel(), item, j);
				} else if (!CheckUtil.isLong(val[j])) {
					super.setMessage(item, j, this.mid, this.prm);
					check = Optional.of(check.orElse(new Pair<>(item, Integer.valueOf(j))));
				}
			}
		}

		check.ifPresent(this::throwKeepCheckException);
	}

	/**
	 * @see online.context.check.ItemConvert#convert(java.lang.String...)
	 */
	@Override
	public Long[] convert(final String... val) {
		return Stream.of(val).map(NumberUtil::toLong).toArray(Long[]::new);
	}
}
