package project.base.upload;

import java.io.InputStream;

import project.base.UpdateAbstract;

/**
 * インポート
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public abstract class ImportAbstract extends UpdateAbstract {

	/** 入力ストリーム */
	private InputStream stream;
	/** レコード総数 */
	private int count;

	/**
	 * 入力ストリーム設定
	 * @param is 入力ストリーム
	 */
	public final void setInputStream(final InputStream is) {
		this.stream = is;
	}

	/**
	 * 入力ストリーム取得
	 * @return 入力ストリーム
	 */
	protected final InputStream getInputStream() {
		return this.stream;
	}

	/**
	 * レコード数取得
	 * @return レコード数
	 */
	public final int getCount() {
		return this.count;
	}

	/**
	 * レコード数設定
	 * @param val レコード数
	 */
	protected final void setCount(final int val) {
		this.count = val;
	}

	/**
	 * チェック
	 * @return チェック結果
	 */
	public abstract boolean check();

	/**
	 * インポート
	 * @return 更新件数
	 */
	public abstract int insert();
}
