CREATE TABLE MS_GENERIC_CSV
(
    ID                          BIGINT PRIMARY KEY,
    DEFINE_NO                   BIGINT NOT NULL,
    DEFINE_NAME                 VARCHAR(100) NOT NULL,
    SCHEMA_NAME                 VARCHAR(32),
    REC_SQL                     TEXT,
    REC_WHERE                   TEXT,
    INSERT_DATETIME             TIMESTAMP   NOT NULL,
    INSERT_ID                   VARCHAR(32) NOT NULL,
    UPDATE_DATETIME             TIMESTAMP   NOT NULL,
    UPDATE_ID                   VARCHAR(32) NOT NULL,
    VERSION                     INTEGER     NOT NULL DEFAULT 1,
    CONSTRAINT MS_GENERIC_CSV_UIX01 UNIQUE (DEFINE_NAME)
)
;

COMMENT ON TABLE MS_GENERIC_CSV IS '汎用CSV管理';
COMMENT ON COLUMN MS_GENERIC_CSV.ID IS 'ID';
COMMENT ON COLUMN MS_GENERIC_CSV.DEFINE_NO IS '定義番号';
COMMENT ON COLUMN MS_GENERIC_CSV.DEFINE_NAME IS '定義名';
COMMENT ON COLUMN MS_GENERIC_CSV.SCHEMA_NAME IS 'スキーマ名';
COMMENT ON COLUMN MS_GENERIC_CSV.REC_SQL IS 'テーブル句';
COMMENT ON COLUMN MS_GENERIC_CSV.REC_WHERE IS '条件句';
COMMENT ON COLUMN MS_GENERIC_CSV.INSERT_DATETIME IS '作成日時';
COMMENT ON COLUMN MS_GENERIC_CSV.INSERT_ID IS '作成者';
COMMENT ON COLUMN MS_GENERIC_CSV.UPDATE_DATETIME IS '更新日時';
COMMENT ON COLUMN MS_GENERIC_CSV.UPDATE_ID IS '更新者';
COMMENT ON COLUMN MS_GENERIC_CSV.VERSION IS 'バージョン';
