package project.master;

import common.master.MasterCache;
import core.config.Env;

/**
 * 事前読込マスター保持
 *
 * @author Tadashi Nakayama
 * @param <K> キー
 * @param <V> 値
 */
public abstract class PreloadMaster<K, V> extends MasterCache<K, V> {

	/**
	 * @see common.master.MasterCache#isPreLoad()
	 */
	@Override
	protected final boolean isPreLoad() {
		return Env.getEnv("MasterCache.preload", true);
	}
}
