#!/bin/sh

trap "/bin/rm -f ${BATCH_HOME}/Batch$$.log" EXIT

cd ${BATCH_HOME}
. ${BATCH_HOME}/sh/classpath.sh

execute() {
    # Pre Process
    JSQ=`${JAVA_HOME}/bin/java batch.BatchStatus -start ID batchname`
    if [ $? -ne 0 ]; then
        return
    fi

    # Process
    ${BATCH_HOME}/batch/bat/sh/RunBatch.sh Batch1 -o $JSQ $*
    if [ $? -ne 0 ]; then
        return
    fi

    # Post Process
    ${JAVA_HOME}/bin/java batch.BatchStatus -continue -o $JSQ
    if [ $? -ne 0 ]; then
        return
    fi

    # Process
    ${BATCH_HOME}/batch/bat/sh/RunBatch.sh Batch2 -o $JSQ $*
    if [ $? -ne 0 ]; then
        return
    fi
}
execute $* 2>> ${BATCH_HOME}/Batch$$.log

# Post Process
${JAVA_HOME}/bin/java batch.BatchStatus -end -o $JSQ 2>> ${BATCH_HOME}/Batch$$.log

exit $?
