package online.view.tag;

import java.util.Objects;

import javax.servlet.jsp.JspException;

import online.view.ViewUtil;

/**
 * URLエンコーディングタグ
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public final class EncodeTag extends BaseTag {
	/** serialVersionUID */
	private static final long serialVersionUID = -6097645204003218758L;

	/** 保存変数名 */
	private String var = null;
	/** 値 */
	private String value = null;
	/** エンコード */
	private String encoding = null;

	/**
	 * リリース処理
	 */
	@Override
	public void release() {
		this.var = null;
		this.value = null;
		this.encoding = null;
	}

	/**
	 * 変数設定
	 *
	 * @param val 保存変数名文字列
	 */
	public void setVar(final String val) {
		this.var = val;
	}

	/**
	 * 値設定
	 *
	 * @param val 値
	 */
	public void setValue(final String val) {
		this.value = val;
	}

	/**
	 * エンコード設定
	 *
	 * @param val エンコード
	 */
	public void setEncoding(final String val) {
		this.encoding = val;
	}

	/**
	 * @see javax.servlet.jsp.tagext.TagSupport#doStartTag()
	 */
	@Override
	public int doStartTag() throws JspException {
		try {
			if (this.var != null) {
				this.pageContext.removeAttribute(this.var);
			}

			if (this.value != null) {
				super.output(this.var, ViewUtil.encode(ViewUtil.taint(this.value, null),
								getEncoding()));
			}
			return SKIP_BODY;
		} finally {
			release();
		}
	}

	/**
	 * エンコード取得
	 * @return エンコード
	 */
	private String getEncoding() {
		return Objects.toString(this.encoding, super.getResponse().getCharacterEncoding());
	}
}
