package online.context.session;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * セション共通情報
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public final class SessionUser implements Serializable {
	/** serialVersionUID */
	private static final long serialVersionUID = 1152688173483661135L;

	/** ユーザID */
	private final String id;
	/** ユーザ属性 */
	private final Map<String, String> attribute = new HashMap<>();

	/**
	 * コンストラクタ
	 *
	 * @param uid ユーザID
	 */
	public SessionUser(final String uid) {
		this.id = uid;
	}

	/**
	 * コンストラクタ
	 *
	 * @param uid ユーザID
	 * @param map ユーザ属性情報
	 */
	public SessionUser(final String uid, final Map<String, String> map) {
		this.id = uid;
		this.attribute.putAll(map);
	}

	/**
	 * ユーザID取得
	 *
	 * @return ユーザID
	 */
	public String getUid() {
		return this.id;
	}

	/**
	 * ユーザ属性情報取得
	 * @param key キー
	 * @return ユーザ属性情報
	 */
	public String getAttribute(final String key) {
		return this.attribute.get(key);
	}

	/**
	 * ユーザ属性情報取得
	 * @return ユーザ属性情報
	 */
	public Map<String, String> getAttributeMap() {
		return Collections.unmodifiableMap(this.attribute);
	}
}
