package core.config;

/**
 * Factory実装クラス
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public final class FactoryImpl extends Factory {

	/**
	 * @see core.config.Factory#getClassInstance(java.lang.Class, java.lang.Class)
	 */
	@Override
	protected <T, U> T getClassInstance(final Class<T> cls, final Class<U> caller) {
		Class<T> c = Factory.loadClass(Factory.getClassName(cls, caller));
		T obj = Factory.invoke(null, Factory.getMethod(c, "getInstance"));
		return obj == null ? Factory.toInstance(c) : obj;
	}
}
