package common.sql;

import java.util.List;
import java.util.Map;

/**
 * パースノードクラス
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public interface LineParsedNode {
	/**
	 * クエリ構築
	 *
	 * @param pmap パラメタマップ
	 * @param plist パラメタリスト
	 * @return クエリ
	 */
	String build(Map<String, ?> pmap, List<Object> plist);

	/**
	 * ターゲット判断
	 *
	 * @param pmap パラメタマップ
	 * @return ターゲットの場合 true を返す。
	 */
	boolean isTarget(Map<String, ?> pmap);
}
