/*
 * $Id: TestActionMessage.java 471754 2006-11-06 14:55:09Z husted $
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.struts.action;

import org.junit.Assert;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

/**
 * Unit tests for the <code>org.apache.struts.action.ActionMessage</code>
 * class.
 *
 * @version $Rev: 471754 $ $Date: 2005-05-19 23:50:06 -0400 (Thu, 19 May 2005)
 *          $
 */
public class TestActionMessage extends TestCase {

    private ActionMessage amWithNoValue = null;
    private ActionMessage amWithOneValue = null;
    private ActionMessage amWithTwoValues = null;
    private ActionMessage amWithThreeValues = null;
    private ActionMessage amWithFourValues = null;
    private ActionMessage amWithArrayValues = null;
    private ActionMessage amWithTwoIntegerValues = null;
    private ActionMessage amNoResource = null;
    private Object[] testValues = new Object[] {
        "stringValue1", "stringValue2", "stringValue3", "stringValue4"
    };

    /**
     * Defines the testcase name for JUnit.
     *
     * @param theName the testcase's name.
     */
    public TestActionMessage(final String theName) {
        super(theName);
    }

    /**
     * Start the tests.
     *
     * @param theArgs the arguments. Not used
     */
    public static void main(final String[] theArgs) {
        junit.textui.TestRunner.main(new String[] {
                TestActionMessage.class.getName()
            });
    }

    /**
     * @return a test suite (<code>TestSuite</code>) that includes all methods
     *         starting with "test"
     */
    public static Test suite() {
        // All methods starting with "test" will be executed in the test suite.
        return new TestSuite(TestActionMessage.class);
    }

    /**
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    public void setUp() {
        this.amWithNoValue = new ActionMessage("amWithNoValue");
        this.amWithOneValue = new ActionMessage("amWithOneValue", "stringValue");
        this.amWithTwoValues = new ActionMessage("amWithTwoValues", "stringValue1",
                "stringValue2");
        this.amWithThreeValues = new ActionMessage("amWithThreeValues", "stringValue1",
                "stringValue2", "stringValue3");
        this.amWithFourValues = new ActionMessage("amWithFourValues", "stringValue1",
                "stringValue2", "stringValue3", "stringValue4");
        this.amWithArrayValues = new ActionMessage("amWithArrayValues", this.testValues);
        this.amWithTwoIntegerValues =
            new ActionMessage("amWithTwoIntegerValues", Integer.valueOf(5),
                Integer.valueOf(10));
        this.amNoResource = new ActionMessage("amNoResource", false);
    }

    /**
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    public void tearDown() {
        this.amWithNoValue = null;
        this.amWithOneValue = null;
        this.amWithTwoValues = null;
        this.amWithThreeValues = null;
        this.amWithFourValues = null;
        this.amWithArrayValues = null;
        this.amWithTwoIntegerValues = null;
        this.amNoResource = null;
    }

    /**
     * testActionMessageWithNoValue
     */
    public void testActionMessageWithNoValue() {
        assertTrue(this.amWithNoValue.getValues().length == 0);
        assertTrue(this.amWithNoValue.isResource());
        Assert.assertEquals(this.amWithNoValue.getKey(), "amWithNoValue");
        assertTrue(this.amWithNoValue.toString().equals("amWithNoValue[]"));
    }

    /**
     * testActionMessageWithAStringValue this.
     */
    public void testActionMessageWithAStringValue() {
        Object[] values = this.amWithOneValue.getValues();

        assertNotNull(values);
        assertTrue(values.length == 1);
        assertTrue(values[0].equals("stringValue"));
        assertTrue(this.amWithOneValue.isResource());
        Assert.assertEquals(this.amWithOneValue.getKey(), "amWithOneValue");
        assertTrue(this.amWithOneValue.toString().equals("amWithOneValue[stringValue]"));
    }

    /**
     * testActionMessageWithTwoValues
     */
    public void testActionMessageWithTwoValues() {
        Object[] values = this.amWithTwoValues.getValues();

        assertNotNull(values);
        assertTrue(values.length == 2);
        assertTrue(values[0].equals("stringValue1"));
        assertTrue(values[1].equals("stringValue2"));
        assertTrue(this.amWithTwoValues.isResource());
        Assert.assertEquals(this.amWithTwoValues.getKey(), "amWithTwoValues");
        assertTrue(this.amWithTwoValues.toString().equals(
                "amWithTwoValues[stringValue1, stringValue2]"));
    }

    /**
     * testActionMessageWithThreeValues
     */
    public void testActionMessageWithThreeValues() {
        Object[] values = this.amWithThreeValues.getValues();

        assertNotNull(values);
        assertTrue(values.length == 3);
        assertTrue(values[0].equals("stringValue1"));
        assertTrue(values[1].equals("stringValue2"));
        assertTrue(values[2].equals("stringValue3"));
        Assert.assertEquals(this.amWithThreeValues.getKey(), "amWithThreeValues");
        assertTrue(this.amWithThreeValues.isResource());
        Assert.assertEquals(this.amWithThreeValues.toString(),
                "amWithThreeValues[stringValue1, stringValue2, stringValue3]");
    }

    /**
     * testActionMessageWithFourValues
     */
    public void testActionMessageWithFourValues() {
        Object[] values = this.amWithFourValues.getValues();

        assertNotNull(values);
        assertTrue(values.length == 4);
        assertTrue(values[0].equals("stringValue1"));
        assertTrue(values[1].equals("stringValue2"));
        assertTrue(values[2].equals("stringValue3"));
        assertTrue(values[3].equals("stringValue4"));
        assertTrue(this.amWithFourValues.isResource());
        Assert.assertEquals(this.amWithFourValues.getKey(), "amWithFourValues");
        Assert.assertEquals(this.amWithFourValues.toString(),
                "amWithFourValues[stringValue1, stringValue2, stringValue3, stringValue4]");
    }

    /**
     * testActionMessageWithArrayValues
     */
    public void testActionMessageWithArrayValues() {
        Object[] values = this.amWithArrayValues.getValues();

        assertNotNull(values);
        Assert.assertEquals(values.length, this.testValues.length);

        for (int i = 0; i < values.length; i++) {
            Assert.assertEquals(values[i], this.testValues[i]);
        }

        assertTrue(this.amWithArrayValues.isResource());
        Assert.assertEquals(this.amWithArrayValues.getKey(), "amWithArrayValues");
        Assert.assertEquals(this.amWithArrayValues.toString(),
                "amWithArrayValues[stringValue1, stringValue2, stringValue3, stringValue4]");
    }

    /**
     * testActionWithTwoIntegers
     */
    public void testActionWithTwoIntegers() {
        Object[] values = this.amWithTwoIntegerValues.getValues();

        assertNotNull(values);
        assertTrue(values.length == 2);
        assertTrue(values[0] instanceof Integer);
        assertTrue(values[0].toString().equals("5"));
        assertTrue(values[1] instanceof Integer);
        assertTrue(values[1].toString().equals("10"));
        assertTrue(this.amWithTwoIntegerValues.isResource());
        Assert.assertEquals(this.amWithTwoIntegerValues.getKey(), "amWithTwoIntegerValues");
        Assert.assertEquals(this.amWithTwoIntegerValues.toString(),
                "amWithTwoIntegerValues[5, 10]");
    }

    /** testActionNoResource */
    public void testActionNoResource() {
        assertTrue(this.amNoResource.getValues().length == 0);
        assertFalse(this.amNoResource.isResource());
        Assert.assertEquals(this.amNoResource.getKey(), "amNoResource");
        Assert.assertEquals(this.amNoResource.toString(), "amNoResource[]");
    }
}
