/*
 * $Id: ContextWrapper.java 471754 2006-11-06 14:55:09Z husted $
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.struts.chain.contexts;

import org.apache.commons.chain2.Context;
import org.apache.struts.chain.commands.util.ClassUtils;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

/**
 * <p> Provide a base class for any Context Implementation which is primarily
 * intended for use in a subchain. </p> <p> Classes which extend
 * <code>ContextWrapper</code> may implement typesafe property methods which
 * also leave their values in the underlying context. </p>
 * @param <K> K
 * @param <V> V
 * @param <T> T
 */
public class ContextWrapper<K, V, T extends Context<K, V>> implements Context<K, V> {

    private final T base;

    /**
     * <p> Instantiate object as a composite around the given Context. </p>
     * @param context Context instance to wrap
     */
    public ContextWrapper(final T context) {
        this.base = context;
    }

    /**
     * Provide the underlying Context for this composite.
     * @return The undelrying Context
     */
    protected T getBaseContext() {
        return this.base;
    }

    // -------------------------------
    // Map interface methods
    // -------------------------------

    /**
     * @see java.util.Map#entrySet()
     */
    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.base.entrySet();
    }

    /**
     * @see java.util.Map#keySet()
     */
    @Override
    public Set<K> keySet() {
        return this.base.keySet();
    }

    /**
     * @see java.util.Map#values()
     */
    @Override
    public Collection<V> values() {
        return this.base.values();
    }

    /**
     * @see java.util.Map#clear()
     */
    @Override
    public void clear() {
        this.base.clear();
    }

    /**
     * @see java.util.Map#putAll(java.util.Map)
     */
    @Override
    public void putAll(final Map<? extends K, ? extends V> map) {
        // ISSUE: Should we check this call to putAll?
        this.base.putAll(map);
    }

    /**
     * @see java.util.Map#remove(java.lang.Object)
     */
    @Override
    public V remove(final Object key) {
        return this.base.remove(key);
    }

    /**
     * @see java.util.Map#put(java.lang.Object, java.lang.Object)
     */
    @Override
    public V put(final K key, final V value) {
        // ISSUE: Should we check this call to put?
        return this.base.put(key, value);
    }

    /**
     * @see java.util.Map#get(java.lang.Object)
     */
    @Override
    public V get(final Object key) {
        return this.base.get(key);
    }

    /**
     * @see java.util.Map#containsValue(java.lang.Object)
     */
    @Override
    public boolean containsValue(final Object o) {
        return this.base.containsValue(o);
    }

    /**
     * @see java.util.Map#containsKey(java.lang.Object)
     */
    @Override
    public boolean containsKey(final Object o) {
        return this.base.containsKey(o);
    }

    /**
     * @see java.util.Map#isEmpty()
     */
    @Override
    public boolean isEmpty() {
        return this.base.isEmpty();
    }

    /**
     * @see java.util.Map#size()
     */
    @Override
    public int size() {
        return this.base.size();
    }

    /**
     * @see org.apache.commons.chain2.Context#retrieve(java.lang.Object)
     */
    @Override
    public <E extends V> E retrieve(final K key) {
        return ClassUtils.cast(this.base.get(key));
    }
}
