/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.hibernate.cfg.Configuration;
import org.hibernate.service.ServiceRegistryBuilder;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;
import org.hibernate.tool.hbm2x.AbstractExporter;
import org.hibernate.tool.hbm2x.ExporterException;

public class Hbm2DDLExporter
extends AbstractExporter {
    protected boolean exportToDatabase = true;
    protected boolean scriptToConsole = true;
    protected boolean schemaUpdate = false;
    protected String delimiter = ";";
    protected boolean drop = false;
    protected boolean create = true;
    protected boolean format = false;
    protected String outputFileName = null;
    protected boolean haltOnError = false;

    public Hbm2DDLExporter() {
    }

    public Hbm2DDLExporter(Configuration cfg, File outputdir) {
        super(cfg, outputdir);
    }

    protected boolean setupBoolProperty(String property, boolean defaultVal) {
        if (!this.getProperties().containsKey(property)) {
            return defaultVal;
        }
        return Boolean.parseBoolean(this.getProperties().getProperty(property));
    }

    protected void setupContext() {
        this.exportToDatabase = this.setupBoolProperty("exportToDatabase", this.exportToDatabase);
        this.scriptToConsole = this.setupBoolProperty("scriptToConsole", this.scriptToConsole);
        this.schemaUpdate = this.setupBoolProperty("schemaUpdate", this.schemaUpdate);
        this.delimiter = this.getProperties().getProperty("delimiter", this.delimiter);
        this.drop = this.setupBoolProperty("drop", this.drop);
        this.create = this.setupBoolProperty("create", this.create);
        this.format = this.setupBoolProperty("format", this.format);
        this.outputFileName = this.getProperties().getProperty("outputFileName", this.outputFileName);
        this.haltOnError = this.setupBoolProperty("haltOnError", this.haltOnError);
        super.setupContext();
    }

    protected void cleanUpContext() {
        super.cleanUpContext();
    }

    protected void doStart() {
        Configuration configuration = this.getConfiguration();
        if (this.schemaUpdate) {
            ServiceRegistryBuilder builder = new ServiceRegistryBuilder();
            builder.applySettings((Map)configuration.getProperties());
            SchemaUpdate update = new SchemaUpdate(builder.buildServiceRegistry(), configuration);
            if (this.outputFileName == null && this.delimiter == null && this.haltOnError && this.format) {
                update.execute(this.scriptToConsole, this.exportToDatabase);
            } else {
                try {
                    Class<SchemaUpdate> schemaUpdateClass = SchemaUpdate.class;
                    if (null != this.outputFileName) {
                        Method setOutputFile = schemaUpdateClass.getMethod("setOutputFile", String.class);
                        setOutputFile.invoke((Object)update, new File(this.getOutputDirectory(), this.outputFileName).toString());
                        this.log.debug("delimiter ='" + this.delimiter + "'");
                        Method setDelimiter = schemaUpdateClass.getMethod("setDelimiter", String.class);
                        setDelimiter.invoke((Object)update, this.delimiter);
                        Method setFormat = schemaUpdateClass.getMethod("setFormat", Boolean.TYPE);
                        setFormat.invoke((Object)update, this.format);
                    }
                    if (this.haltOnError) {
                        Method setHaltOnError = schemaUpdateClass.getMethod("setHaltOnError", Boolean.TYPE);
                        setHaltOnError.invoke((Object)update, this.haltOnError);
                    }
                    update.execute(this.scriptToConsole, this.exportToDatabase);
                    if (!update.getExceptions().isEmpty()) {
                        int i = 1;
                        for (Throwable element : update.getExceptions()) {
                            this.log.warn("Error #" + i + ": ", element);
                            ++i;
                        }
                        this.log.error(i - 1 + " errors occurred while performing Hbm2DDLExporter.");
                        if (this.haltOnError) {
                            throw new ExporterException("Errors while performing Hbm2DDLExporter");
                        }
                    }
                }
                catch (NoSuchMethodException e) {
                    this.log.error("Error during DDL export, this version of hibernate doesn't support following SchemaUpdate parameters: haltonerror = true, format= true, delimiter and outputfilename either update hibernate3.jar or don't used the involved parameters", (Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    this.log.error("Error during DDL export, this version of hibernate doesn't support following SchemaUpdate parameters: haltonerror = true, format= true, delimiter and outputfilename either update hibernate3.jar or don't used the involved parameters", (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    this.log.error("Error during DDL export, this version of hibernate doesn't support following SchemaUpdate parameters: haltonerror = true, format= true, delimiter and outputfilename either update hibernate3.jar or don't used the involved parameters", (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    this.log.error("Error during DDL export, this version of hibernate doesn't support following SchemaUpdate parameters: haltonerror = true, format= true, delimiter and outputfilename either update hibernate3.jar or don't used the involved parameters", (Throwable)e);
                }
            }
        } else {
            ServiceRegistryBuilder builder = new ServiceRegistryBuilder();
            builder.applySettings((Map)configuration.getProperties());
            SchemaExport export = new SchemaExport(builder.buildServiceRegistry(), configuration);
            if (null != this.outputFileName) {
                export.setOutputFile(new File(this.getOutputDirectory(), this.outputFileName).toString());
            }
            if (null != this.delimiter) {
                export.setDelimiter(this.delimiter);
            }
            export.setHaltOnError(this.haltOnError);
            export.setFormat(this.format);
            if (this.drop && this.create) {
                export.execute(this.scriptToConsole, this.exportToDatabase, false, false);
            } else {
                export.execute(this.scriptToConsole, this.exportToDatabase, this.drop, this.create);
            }
        }
    }

    public void setExport(boolean export) {
        this.exportToDatabase = export;
    }

    public void setUpdate(boolean update) {
        this.schemaUpdate = update;
    }

    public void setConsole(boolean console) {
        this.scriptToConsole = console;
    }

    public void setFormat(boolean format) {
        this.format = format;
    }

    public void setOutputFileName(String fileName) {
        this.outputFileName = fileName;
    }

    public void setDrop(boolean drop) {
        this.drop = drop;
    }

    public void setCreate(boolean create) {
        this.create = create;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setHaltonerror(boolean haltOnError) {
        this.haltOnError = haltOnError;
    }
}

