/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.types;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.extension.jdbc.types.AbstractValueType;
import org.seasar.extension.jdbc.util.BindVariableUtil;
import org.seasar.framework.util.ByteConversionUtil;

public class ByteType
extends AbstractValueType {
    public ByteType() {
        super(5);
    }

    public Object getValue(ResultSet resultSet, int index) throws SQLException {
        return ByteConversionUtil.toByte((Object)resultSet.getObject(index));
    }

    public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
        return ByteConversionUtil.toByte((Object)resultSet.getObject(columnName));
    }

    public Object getValue(CallableStatement cs, int index) throws SQLException {
        return ByteConversionUtil.toByte((Object)cs.getObject(index));
    }

    public Object getValue(CallableStatement cs, String parameterName) throws SQLException {
        return ByteConversionUtil.toByte((Object)cs.getObject(parameterName));
    }

    public void bindValue(PreparedStatement ps, int index, Object value) throws SQLException {
        if (value == null) {
            this.setNull(ps, index);
        } else {
            ps.setByte(index, ByteConversionUtil.toPrimitiveByte((Object)value));
        }
    }

    public void bindValue(CallableStatement cs, String parameterName, Object value) throws SQLException {
        if (value == null) {
            this.setNull(cs, parameterName);
        } else {
            cs.setByte(parameterName, ByteConversionUtil.toPrimitiveByte((Object)value));
        }
    }

    public String toText(Object value) {
        if (value == null) {
            return BindVariableUtil.nullText();
        }
        Byte var = ByteConversionUtil.toByte((Object)value);
        return BindVariableUtil.toText(var);
    }
}

