/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.impl;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.seasar.framework.exception.SSQLException;

public class PreparedStatementWrapper
implements PreparedStatement {
    private final PreparedStatement original;
    private final String sql;

    public PreparedStatementWrapper(PreparedStatement original, String sql) {
        this.original = original;
        this.sql = sql;
    }

    private SQLException wrapException(SQLException e) {
        return this.wrapException(e, this.sql);
    }

    private SQLException wrapException(SQLException e, String sql) {
        if (sql != null) {
            return new SSQLException("ESSR0072", new Object[]{sql, String.valueOf(e.getErrorCode()), e.getSQLState()}, e.getSQLState(), e.getErrorCode(), (Throwable)e, sql);
        }
        return e;
    }

    public ResultSet executeQuery() throws SQLException {
        try {
            return this.original.executeQuery();
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public int executeUpdate() throws SQLException {
        try {
            return this.original.executeUpdate();
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            return this.original.getMetaData();
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        try {
            return this.original.getParameterMetaData();
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public int getMaxRows() throws SQLException {
        try {
            return this.original.getMaxRows();
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public int getQueryTimeout() throws SQLException {
        return this.original.getQueryTimeout();
    }

    public SQLWarning getWarnings() throws SQLException {
        try {
            return this.original.getWarnings();
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public ResultSet getResultSet() throws SQLException {
        try {
            return this.original.getResultSet();
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public int getUpdateCount() throws SQLException {
        try {
            return this.original.getUpdateCount();
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public boolean getMoreResults() throws SQLException {
        try {
            return this.original.getMoreResults();
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public int getFetchDirection() throws SQLException {
        try {
            return this.original.getFetchDirection();
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public int getFetchSize() throws SQLException {
        try {
            return this.original.getFetchSize();
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public int getResultSetConcurrency() throws SQLException {
        try {
            return this.original.getResultSetConcurrency();
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public int getResultSetType() throws SQLException {
        try {
            return this.original.getResultSetType();
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public int[] executeBatch() throws SQLException {
        try {
            return this.original.executeBatch();
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public Connection getConnection() throws SQLException {
        try {
            return this.original.getConnection();
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public boolean getMoreResults(int current) throws SQLException {
        try {
            return this.original.getMoreResults();
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        try {
            return this.original.getGeneratedKeys();
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            return this.original.executeUpdate();
        }
        catch (SQLException e) {
            throw this.wrapException(e, sql);
        }
    }

    public int getResultSetHoldability() throws SQLException {
        try {
            return this.original.getResultSetHoldability();
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public void addBatch() throws SQLException {
        try {
            this.original.addBatch();
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public void addBatch(String sql) throws SQLException {
        try {
            this.original.addBatch(sql);
        }
        catch (SQLException e) {
            throw this.wrapException(e, sql);
        }
    }

    public void cancel() throws SQLException {
        try {
            this.original.cancel();
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public void clearBatch() throws SQLException {
        try {
            this.original.clearBatch();
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public void clearParameters() throws SQLException {
        try {
            this.original.clearParameters();
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public void clearWarnings() throws SQLException {
        try {
            this.original.clearWarnings();
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public void close() throws SQLException {
        try {
            this.original.close();
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public boolean execute() throws SQLException {
        try {
            return this.original.execute();
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            return this.original.execute(sql, autoGeneratedKeys);
        }
        catch (SQLException e) {
            throw this.wrapException(e, sql);
        }
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        try {
            return this.original.execute(sql, columnIndexes);
        }
        catch (SQLException e) {
            throw this.wrapException(e, sql);
        }
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        try {
            return this.original.execute(sql, columnNames);
        }
        catch (SQLException e) {
            throw this.wrapException(e, sql);
        }
    }

    public boolean execute(String sql) throws SQLException {
        try {
            return this.original.execute(sql);
        }
        catch (SQLException e) {
            throw this.wrapException(e, sql);
        }
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        try {
            return this.original.executeQuery(sql);
        }
        catch (SQLException e) {
            throw this.wrapException(e, sql);
        }
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        try {
            return this.original.executeUpdate(sql, columnIndexes);
        }
        catch (SQLException e) {
            throw this.wrapException(e, sql);
        }
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        try {
            return this.original.executeUpdate(sql, columnNames);
        }
        catch (SQLException e) {
            throw this.wrapException(e, sql);
        }
    }

    public int executeUpdate(String sql) throws SQLException {
        try {
            return this.original.executeUpdate(sql);
        }
        catch (SQLException e) {
            throw this.wrapException(e, sql);
        }
    }

    public int getMaxFieldSize() throws SQLException {
        try {
            return this.original.getMaxFieldSize();
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public void setArray(int i, Array x) throws SQLException {
        try {
            this.original.setArray(i, x);
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        try {
            this.original.setAsciiStream(parameterIndex, x, length);
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        try {
            this.original.setBigDecimal(parameterIndex, x);
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        try {
            this.original.setBinaryStream(parameterIndex, x, length);
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public void setBlob(int i, Blob x) throws SQLException {
        try {
            this.original.setBlob(i, x);
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        try {
            this.original.setBoolean(parameterIndex, x);
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        try {
            this.original.setByte(parameterIndex, x);
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        try {
            this.original.setBytes(parameterIndex, x);
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        try {
            this.original.setCharacterStream(parameterIndex, reader, length);
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public void setClob(int i, Clob x) throws SQLException {
        try {
            this.original.setClob(i, x);
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public void setCursorName(String name) throws SQLException {
        try {
            this.original.setCursorName(name);
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        try {
            this.original.setDate(parameterIndex, x, cal);
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        try {
            this.original.setDate(parameterIndex, x);
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        try {
            this.original.setDouble(parameterIndex, x);
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        try {
            this.original.setEscapeProcessing(enable);
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public void setFetchDirection(int direction) throws SQLException {
        try {
            this.original.setFetchDirection(direction);
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public void setFetchSize(int rows) throws SQLException {
        try {
            this.original.setFetchSize(rows);
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        try {
            this.original.setFloat(parameterIndex, x);
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        try {
            this.original.setInt(parameterIndex, x);
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        try {
            this.original.setLong(parameterIndex, x);
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public void setMaxFieldSize(int max) throws SQLException {
        try {
            this.original.setMaxFieldSize(max);
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public void setMaxRows(int max) throws SQLException {
        try {
            this.original.setMaxRows(max);
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        try {
            this.original.setNull(paramIndex, sqlType, typeName);
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        try {
            this.original.setNull(parameterIndex, sqlType);
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        try {
            this.original.setObject(parameterIndex, x, targetSqlType, scale);
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        try {
            this.original.setObject(parameterIndex, x, targetSqlType);
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        try {
            this.original.setObject(parameterIndex, x);
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        try {
            this.original.setQueryTimeout(seconds);
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public void setRef(int i, Ref x) throws SQLException {
        try {
            this.original.setRef(i, x);
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        try {
            this.original.setShort(parameterIndex, x);
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        try {
            this.original.setString(parameterIndex, x);
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        try {
            this.original.setTime(parameterIndex, x, cal);
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        try {
            this.original.setTime(parameterIndex, x);
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        try {
            this.original.setTimestamp(parameterIndex, x, cal);
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        try {
            this.original.setTimestamp(parameterIndex, x);
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        try {
            this.original.setUnicodeStream(parameterIndex, x, length);
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        try {
            this.original.setURL(parameterIndex, x);
        }
        catch (SQLException e) {
            throw this.wrapException(e);
        }
    }

    public String toString() {
        return this.original.toString();
    }
}

