package core.util.bean;

import java.util.Optional;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

/**
 * CamelCaseTest
 *
 * @author Tadashi Nakayama
 */
public class CamelCaseTest {

	/**
	 * テストターゲット取得
	 *
	 * @param bool 引数
	 * @return テストターゲット
	 */
	private CamelCase getTarget(final Boolean bool) {
		return Optional.ofNullable(bool).map(CamelCase::new).orElseGet(CamelCase::new);
	}

	/**
	 * 先頭小文字
	 */
	@Test
	@DisplayName("先頭小文字")
	public void testToCamelCase1() {
		final var target = getTarget(null);
		Assertions.assertEquals("abCdEf", target.toCamelCase("AB_CD_ef"));
	}

	/**
	 * 先頭大毛寺
	 */
	@Test
	@DisplayName("先頭大文字")
	public void testToCamelCase2() {
		final var target = getTarget(Boolean.TRUE);
		Assertions.assertEquals("AbCdEf", target.toCamelCase("AB_CD_eF"));
	}
}
