package common.sql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

/**
 * QueryUtilTest
 *
 * @author Tadashi Nakayama
 */
public class QueryUtilTest {

	/**
	 * パラメータマップ取得
	 *
	 * @param vals 値
	 * @return パラメータマップ
	 */
	private Map<String, Object> getParameterMap(final Object... vals) {
		return Stream.of(vals).collect(HashMap::new,
				(m, v) -> m.put(String.valueOf(m.size() + 1), v), HashMap::putAll);
	}

	/**
	 * case1
	 */
	@Test
	public void testToPrepareQuery() {
		final var map = getParameterMap("aaaa", "bbbb");

		Assertions.assertEquals("aaaa", Objects.toString(map.get("1")));
		Assertions.assertEquals("bbbb", Objects.toString(map.get("2")));

		final var query = """
				SELECT
				  VERSION
				FROM
				  FW_JOB_REPEAT
				WHERE
				  D = /*:1*/'1223'
				  AND ID = 1223
				""";

		final var list = new ArrayList<>();
		QueryUtil.toPrepareQuery(query, map, list);

		Assertions.assertEquals(1, list.size());
		Assertions.assertEquals("aaaa", list.get(0));
	}

	/**
	 * case2
	 */
	@Test
	public void getCodeMaster() {
		final var query = "select * from ms_code where cd_sbt = /*:1*/'' order by cd_sbt, cd ";

		final var map = getParameterMap("value");

		final var list = new ArrayList<>();
		QueryUtil.toPrepareQuery(query, map, list);

		Assertions.assertEquals(1, list.size());
		Assertions.assertEquals("value", list.get(0));
	}
}
