package common.sql;

import java.sql.Connection;

/**
 * DB検索処理
 *
 * @author Tadashi Nakayama
 */
public interface Selector {

	/**
	 * 取得サイズ設定
	 *
	 * @param size サイズ
	 */
	void setFetchSize(int size);

	/**
	 * 最大レコード数設定
	 *
	 * @param size レコード数
	 */
	void setMaxRows(int size);

	/**
	 * コネクション設定
	 *
	 * @param conn コネクション
	 */
	void setConnection(Connection conn);

	/**
	 * データ検索
	 *
	 * @param sel クエリオブジェクト
	 * @return レコードが存在した場合 true を返す。
	 */
	boolean search(SelectQuery... sel);
}
