CREATE TABLE TR_GENERIC_CSV_BATCH
(
    ID                          BIGINT        PRIMARY KEY,
    BATCH_NAME                  VARCHAR(128)  NOT NULL,
    USER_PATTERN_ID             VARCHAR(2048) NOT NULL,
    REPEAT_ID                   BIGINT,
    INSERT_DATETIME             TIMESTAMP     NOT NULL,
    INSERT_ID                   VARCHAR(32)   NOT NULL,
    UPDATE_DATETIME             TIMESTAMP     NOT NULL,
    UPDATE_ID                   VARCHAR(32)   NOT NULL,
    VERSION                     INTEGER       NOT NULL DEFAULT 1
)
;
CREATE INDEX TR_GENERIC_CSV_BATCH_IDX01 ON TR_GENERIC_CSV_BATCH(BATCH_NAME, INSERT_ID);

COMMENT ON TABLE TR_GENERIC_CSV_BATCH IS '汎用CSV一括登録';
COMMENT ON COLUMN TR_GENERIC_CSV_BATCH.ID IS 'ID';
COMMENT ON COLUMN TR_GENERIC_CSV_BATCH.BATCH_NAME IS '一括登録名';
COMMENT ON COLUMN TR_GENERIC_CSV_BATCH.USER_PATTERN_ID IS 'ユーザパターンID';
COMMENT ON COLUMN TR_GENERIC_CSV_BATCH.REPEAT_ID IS '定期起動ID';
COMMENT ON COLUMN TR_GENERIC_CSV_BATCH.INSERT_DATETIME IS '作成日時';
COMMENT ON COLUMN TR_GENERIC_CSV_BATCH.INSERT_ID IS '作成ID';
COMMENT ON COLUMN TR_GENERIC_CSV_BATCH.UPDATE_DATETIME IS '更新日時';
COMMENT ON COLUMN TR_GENERIC_CSV_BATCH.UPDATE_ID IS '更新ID';
COMMENT ON COLUMN TR_GENERIC_CSV_BATCH.VERSION IS 'バージョン';
