package online.jpa.producer;

import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;

/**
 * CDI供給用
 *
 * @author Tadashi Nakayama
 */
public class EntityManagerProducer {

    /**
     * EntityManager作成
     *
     * @return EntityManager
     */
    @Produces
    @RequestScoped
    public EntityManager create() {
        final EntityManagerFactory emf = Persistence.createEntityManagerFactory("defaultUnit");
        return emf.createEntityManager();
    }

    /**
     * EntityManagerクローズ
     *
     * @param entityManager EntityManager
     */
    public void closeEntityManager(@Disposes final EntityManager entityManager) {
        if (entityManager.isOpen()) {
            entityManager.close();
        }
    }
}
