/*
 * Decompiled with CFR 0.152.
 */
package jdd.graph;

import java.util.Enumeration;
import jdd.graph.Edge;
import jdd.graph.Graph;
import jdd.graph.Node;

public class AttributeExplorer {
    public static void setEdgeFlag(Graph graph, int n) {
        Enumeration enumeration = graph.getEdges().elements();
        while (enumeration.hasMoreElements()) {
            ((Edge)enumeration.nextElement()).flags |= n;
        }
    }

    public static void resetEdgeFlag(Graph graph, int n) {
        n ^= 0xFFFFFFFF;
        Enumeration enumeration = graph.getEdges().elements();
        while (enumeration.hasMoreElements()) {
            ((Edge)enumeration.nextElement()).flags &= n;
        }
    }

    public static int countEdgeFlag(Graph graph, int n) {
        int n2 = 0;
        Enumeration enumeration = graph.getEdges().elements();
        while (enumeration.hasMoreElements()) {
            if ((((Edge)enumeration.nextElement()).flags & n) != n) continue;
            ++n2;
        }
        return n2;
    }

    public static double sumEdgeWeights(Graph graph) {
        double d = 0.0;
        Enumeration enumeration = graph.getEdges().elements();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            d += edge.weight;
        }
        return d;
    }

    public static double sumEdgeWeightsIf(Graph graph, int n) {
        double d = 0.0;
        Enumeration enumeration = graph.getEdges().elements();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if ((edge.flags & n) != n) continue;
            d += edge.weight;
        }
        return d;
    }

    public static void setAllEdgesExtra1(Graph graph, int n) {
        Enumeration enumeration = graph.getEdges().elements();
        while (enumeration.hasMoreElements()) {
            ((Edge)enumeration.nextElement()).extra1 = n;
        }
    }

    public static void changeAllEdgeFlags(Graph graph, int n, int n2) {
        n2 ^= 0xFFFFFFFF;
        Enumeration enumeration = graph.getEdges().elements();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            edge.flags = edge.flags & n2 | n;
        }
    }

    public static void setNodeFlag(Graph graph, int n) {
        Enumeration enumeration = graph.getNodes().elements();
        while (enumeration.hasMoreElements()) {
            ((Node)enumeration.nextElement()).flags |= n;
        }
    }

    public static void resetNodeFlag(Graph graph, int n) {
        n ^= 0xFFFFFFFF;
        Enumeration enumeration = graph.getNodes().elements();
        while (enumeration.hasMoreElements()) {
            ((Node)enumeration.nextElement()).flags &= n;
        }
    }

    public static int countNodeFlag(Graph graph, int n) {
        int n2 = 0;
        Enumeration enumeration = graph.getNodes().elements();
        while (enumeration.hasMoreElements()) {
            if ((((Node)enumeration.nextElement()).flags & n) != n) continue;
            ++n2;
        }
        return n2;
    }

    public static double sumNodeWeights(Graph graph) {
        double d = 0.0;
        Enumeration enumeration = graph.getNodes().elements();
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            d += node.weight;
        }
        return d;
    }

    public static double sumNodeWeightsIf(Graph graph, int n) {
        double d = 0.0;
        Enumeration enumeration = graph.getNodes().elements();
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            if ((node.flags & n) != n) continue;
            d += node.weight;
        }
        return d;
    }

    public static void changeAllNodesFlag(Graph graph, int n, int n2) {
        n2 ^= 0xFFFFFFFF;
        Enumeration enumeration = graph.getNodes().elements();
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            node.flags = node.flags & n2 | n;
        }
    }

    public static void setAllNodesExtra1(Graph graph, int n) {
        Enumeration enumeration = graph.getNodes().elements();
        while (enumeration.hasMoreElements()) {
            ((Node)enumeration.nextElement()).extra1 = n;
        }
    }

    public static void setAllNodesExtra3(Graph graph, double d) {
        Enumeration enumeration = graph.getNodes().elements();
        while (enumeration.hasMoreElements()) {
            ((Node)enumeration.nextElement()).extra3 = d;
        }
    }

    public static void updateExtraIndex(Graph graph) {
        int n = 0;
        Enumeration enumeration = graph.getNodes().elements();
        while (enumeration.hasMoreElements()) {
            ((Node)enumeration.nextElement()).extraindex = n++;
        }
    }

    public static Node findExtra1(Graph graph, int n) {
        Enumeration enumeration = graph.getNodes().elements();
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            if (node.extra1 != n) continue;
            return node;
        }
        return null;
    }
}

