/*
 * Decompiled with CFR 0.152.
 */
package jdd.des.automata.analysis;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.AbstractSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import jdd.des.automata.Automata;
import jdd.des.automata.AutomataIO;
import jdd.des.automata.Automaton;
import jdd.des.automata.Event;
import jdd.des.automata.EventManager;
import jdd.des.automata.Transition;
import jdd.des.automata.analysis.AutomataAnalyzerData;
import jdd.graph.ApproximationAlgorithms;
import jdd.graph.AttributeExplorer;
import jdd.graph.Graph;
import jdd.graph.GraphOperation;
import jdd.graph.MinimumSpanningTree;
import jdd.graph.Node;
import jdd.graph.SimpleAlgorithms;
import jdd.graph.WeakTopologicalOrdering;
import jdd.graph.WeightedGraph;
import jdd.util.Array;
import jdd.util.JDDConsole;
import jdd.util.Test;
import jdd.util.math.ArrayAnalyzer;

public class AutomataAnalyzer {
    public static Graph getPCG(Automata automata) {
        return AutomataAnalyzer.getPCG(automata, null, null);
    }

    public static Graph getPCG(Automata automata, HashMap hashMap, HashMap hashMap2) {
        Node node;
        Automaton automaton;
        int n;
        WeightedGraph weightedGraph = new WeightedGraph(false);
        Object[] objectArray = automata.toArray();
        if (hashMap2 == null) {
            hashMap2 = new HashMap<Automaton, Node>(objectArray.length);
        }
        if (hashMap != null) {
            hashMap.clear();
        }
        for (n = 0; n < objectArray.length; ++n) {
            automaton = (Automaton)objectArray[n];
            node = weightedGraph.addNode();
            node.weight = automaton.numOfNodes();
            node.setLabel(automaton.getName());
            hashMap2.put(automaton, node);
            if (hashMap == null) continue;
            hashMap.put(node, automaton);
        }
        for (n = 0; n < objectArray.length; ++n) {
            automaton = (Automaton)objectArray[n];
            node = (Node)hashMap2.get(automaton);
            for (int i = 0; i < n; ++i) {
                Automaton automaton2 = (Automaton)objectArray[i];
                int n2 = automaton.sharedEvents(automaton2);
                if (n2 <= 0) continue;
                Node node2 = (Node)hashMap2.get(automaton2);
                weightedGraph.addEdge(node, node2, n2);
            }
        }
        return weightedGraph;
    }

    public static boolean[] dependencyGroup(Automata automata, Automaton automaton, boolean[] blArray) {
        if (blArray == null) {
            blArray = new boolean[automata.size()];
        }
        Array.set(blArray, false);
        int n = 0;
        Object object = automata.elements();
        while (object.hasMoreElements()) {
            ((Automaton)object.nextElement()).extra1 = n++;
        }
        object = automaton.getAlphabet();
        Event event = automaton.getAlphabet().head();
        while (event != null) {
            Enumeration enumeration = event.parent.users.elements();
            while (enumeration.hasMoreElements()) {
                blArray[((Automaton)enumeration.nextElement()).extra1] = true;
            }
            event = event.next;
        }
        return blArray;
    }

    public static int countEventUsage(Automaton automaton, Event event) {
        int n = 0;
        Enumeration enumeration = automaton.getEdges().elements();
        while (enumeration.hasMoreElements()) {
            Transition transition = (Transition)enumeration.nextElement();
            if (transition.event != event) continue;
            ++n;
        }
        return n;
    }

    public static void computeEventProbability(Automaton automaton) {
        double d = automaton.numOfNodes();
        Test.check(d != 0.0);
        Object object = automaton.getAlphabet().head();
        while (object != null) {
            ((Event)object).extra1 = 0;
            object = ((Event)object).next;
        }
        object = automaton.getEdges().elements();
        while (object.hasMoreElements()) {
            Transition transition = (Transition)object.nextElement();
            ++transition.event.extra1;
        }
        object = automaton.getAlphabet().head();
        while (object != null) {
            ((Event)object).probability = (double)((Event)object).extra1 / d;
            object = ((Event)object).next;
        }
    }

    public static void computeEventProbability(Automata automata) {
        EventManager eventManager = automata.getEventManager();
        Object object = eventManager.head();
        while (object != null) {
            ((Event)object).probability = 1.0;
            object = ((Event)object).next;
        }
        object = automata.elements();
        while (object.hasMoreElements()) {
            Automaton automaton = (Automaton)object.nextElement();
            AutomataAnalyzer.computeEventProbability(automaton);
            Event event = automaton.getAlphabet().head();
            while (event != null) {
                event.parent.probability *= event.probability;
                event = event.next;
            }
        }
    }

    public static void showEventProbability(Automaton automaton) {
        AutomataAnalyzer.computeEventProbability(automaton);
        JDDConsole.out.println("Transition probability for " + automaton.getName());
        JDDConsole.out.println("Probability\tEvent");
        JDDConsole.out.println("------------------------------");
        Event event = automaton.getAlphabet().head();
        while (event != null) {
            double d = (double)((int)(event.probability * 1000.0)) / 1000.0;
            JDDConsole.out.println("" + d + "\t\t" + event.getLabel());
            event = event.next;
        }
        JDDConsole.out.println();
    }

    public static AutomataAnalyzerData analyze(Automata automata, String string) {
        Object object;
        Automaton automaton;
        AutomataAnalyzerData automataAnalyzerData = new AutomataAnalyzerData();
        String string2 = automataAnalyzerData.file = string;
        int n = string.lastIndexOf(58);
        if (n != -1) {
            string2 = string2.substring(n + 1, string2.length());
        }
        if ((n = string2.lastIndexOf(46)) != -1) {
            string2 = string2.substring(0, n);
        }
        automataAnalyzerData.internal_name = string2 = string2.replace('/', '_').replace('\\', '_').replace(File.pathSeparatorChar, '_');
        Graph graph = automataAnalyzerData.pcg = AutomataAnalyzer.getPCG(automata);
        automataAnalyzerData.wto = WeakTopologicalOrdering.bourdoncle(graph);
        EventManager eventManager = automata.getEventManager();
        ArrayAnalyzer arrayAnalyzer = new ArrayAnalyzer();
        Vector vector = graph.getNodes();
        double d = automata.maxNumOfGlobalStates();
        int n2 = SimpleAlgorithms.number_of_islands(graph);
        double d2 = AttributeExplorer.sumEdgeWeights(graph);
        double d3 = automata.size();
        double d4 = automata.numOfEvents();
        double d5 = graph.numOfEdges();
        double[] dArray = new double[(int)Math.max(d4, d3)];
        automataAnalyzerData.num_automata = graph.numOfNodes();
        automataAnalyzerData.num_events = eventManager.getSize();
        automataAnalyzerData.max_states = d;
        automataAnalyzerData.g_num_edges = graph.numOfEdges();
        automataAnalyzerData.g_num_island = n2;
        automataAnalyzerData.g_sum_weight = d2;
        int n3 = 0;
        Enumeration enumeration = automata.elements();
        while (enumeration.hasMoreElements()) {
            automaton = (Automaton)enumeration.nextElement();
            dArray[n3++] = automaton.numOfNodes();
        }
        arrayAnalyzer.analyze(dArray, n3);
        automataAnalyzerData.state_dist_min = arrayAnalyzer.min;
        automataAnalyzerData.state_dist_max = arrayAnalyzer.max;
        automataAnalyzerData.state_dist_avg = arrayAnalyzer.average;
        automataAnalyzerData.state_dist_dev = arrayAnalyzer.std_deveiation;
        n3 = 0;
        enumeration = automata.elements();
        while (enumeration.hasMoreElements()) {
            automaton = (Automaton)enumeration.nextElement();
            dArray[n3++] = (double)automaton.getAlphabet().getSize() / d4;
        }
        arrayAnalyzer.analyze(dArray, n3);
        automataAnalyzerData.event_dist_min = arrayAnalyzer.min;
        automataAnalyzerData.event_dist_max = arrayAnalyzer.max;
        automataAnalyzerData.event_dist_avg = arrayAnalyzer.average;
        automataAnalyzerData.event_dist_dev = arrayAnalyzer.std_deveiation;
        MinimumSpanningTree.kruskal(graph);
        automataAnalyzerData.mst = GraphOperation.clone(graph);
        double d6 = (double)AttributeExplorer.countEdgeFlag(graph, 1) / d5;
        double d7 = AttributeExplorer.sumEdgeWeightsIf(graph, 1) / d2;
        automataAnalyzerData.g_mst_edges = d6;
        automataAnalyzerData.g_mst_weight = d7;
        AttributeExplorer.resetEdgeFlag(graph, 1);
        ApproximationAlgorithms.approx_vertex_cover_ED(graph);
        double d8 = (double)AttributeExplorer.countNodeFlag(graph, 2) / d3;
        ApproximationAlgorithms.approx_vertex_cover_MDG(graph);
        double d9 = (double)AttributeExplorer.countNodeFlag(graph, 2) / d3;
        AttributeExplorer.resetNodeFlag(graph, 2);
        automataAnalyzerData.g_vcnodes_ed = d8;
        automataAnalyzerData.g_vcnodes_mdg = d9;
        n3 = 0;
        Object object2 = graph.getNodes().elements();
        while (object2.hasMoreElements()) {
            object = (Node)object2.nextElement();
            dArray[n3++] = (double)(1 + ((Node)object).getDegree()) / d3;
        }
        arrayAnalyzer.analyze(dArray, n3);
        automataAnalyzerData.level1_dep_min = arrayAnalyzer.min;
        automataAnalyzerData.level1_dep_max = arrayAnalyzer.max;
        automataAnalyzerData.level1_dep_avg = arrayAnalyzer.average;
        automataAnalyzerData.level1_dep_dev = arrayAnalyzer.std_deveiation;
        automataAnalyzerData.level1_dep_min_name = ((Node)vector.elementAt(arrayAnalyzer.index_min)).getLabel();
        automataAnalyzerData.level1_dep_max_name = ((Node)vector.elementAt(arrayAnalyzer.index_max)).getLabel();
        n3 = 0;
        object2 = new HashSet();
        object = graph.getNodes().elements();
        while (object.hasMoreElements()) {
            Node node = (Node)object.nextElement();
            dArray[n3++] = (double)(1 + SimpleAlgorithms.level_n_degree(node, 2, (AbstractSet)object2)) / d3;
        }
        arrayAnalyzer.analyze(dArray, n3);
        automataAnalyzerData.level2_dep_min = arrayAnalyzer.min;
        automataAnalyzerData.level2_dep_max = arrayAnalyzer.max;
        automataAnalyzerData.level2_dep_avg = arrayAnalyzer.average;
        automataAnalyzerData.level2_dep_dev = arrayAnalyzer.std_deveiation;
        automataAnalyzerData.level2_dep_min_name = ((Node)vector.elementAt(arrayAnalyzer.index_min)).getLabel();
        automataAnalyzerData.level2_dep_max_name = ((Node)vector.elementAt(arrayAnalyzer.index_max)).getLabel();
        AutomataAnalyzer.computeEventProbability(automata);
        n3 = 0;
        automataAnalyzerData.estimated_branching_factor = 0.0;
        object = eventManager.head();
        while (object != null) {
            dArray[n3++] = ((Event)object).probability;
            automataAnalyzerData.estimated_branching_factor += ((Event)object).probability;
            object = ((Event)object).next;
        }
        arrayAnalyzer.analyze(dArray, n3);
        automataAnalyzerData.event_prob_min = arrayAnalyzer.min;
        automataAnalyzerData.event_prob_max = arrayAnalyzer.max;
        automataAnalyzerData.event_prob_avg = arrayAnalyzer.average;
        automataAnalyzerData.event_prob_dev = arrayAnalyzer.std_deveiation;
        automataAnalyzerData.event_prob_min_name = eventManager.findByOrder(arrayAnalyzer.index_min).getLabel();
        automataAnalyzerData.event_prob_max_name = eventManager.findByOrder(arrayAnalyzer.index_max).getLabel();
        return automataAnalyzerData;
    }

    public static void loadAndAnalyzeZip(String string) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(string);
        ZipInputStream zipInputStream = new ZipInputStream(fileInputStream);
        AutomataAnalyzerData.printHeader();
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipInputStream.available() != 0) {
            Automata automata;
            if (!zipEntry.isDirectory() && (automata = AutomataIO.loadXML(zipInputStream)) != null) {
                AutomataAnalyzerData automataAnalyzerData = AutomataAnalyzer.analyze(automata, zipEntry.getName());
                automataAnalyzerData.print();
            }
            zipInputStream.closeEntry();
            zipEntry = zipInputStream.getNextEntry();
        }
        zipInputStream.close();
        ((InputStream)fileInputStream).close();
    }

    public static void loadAndAnalyzeXML(String string) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(string);
        Automata automata = AutomataIO.loadXML(fileInputStream);
        if (automata != null) {
            AutomataAnalyzerData automataAnalyzerData = AutomataAnalyzer.analyze(automata, string);
            automataAnalyzerData.printOne();
        } else {
            JDDConsole.out.println("No automata found in " + string);
        }
        ((InputStream)fileInputStream).close();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.err.println("Usage: Java jdd.des.automata.AutomataAnalyzer [ Supremica file.xml> | <Supremica XML-files.zip>]");
            System.exit(20);
        }
        try {
            if (stringArray[0].endsWith(".zip")) {
                AutomataAnalyzer.loadAndAnalyzeZip(stringArray[0]);
            } else {
                AutomataAnalyzer.loadAndAnalyzeXML(stringArray[0]);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

