/***************************************************************************/
/** @file       input_raw_mouse.h
	@brief      
	@author     shom
	@internal
****************************************************************************/

#pragma once

#include "input_raw_base.h"

#include "core/input/input_mouse_def.h"


class cinput_raw_mouse
:
public cinput_raw_base
{
public:
	cinput_raw_mouse(
#ifdef DX
		LPDIRECTINPUT8 p_dinput
#endif
		);

	virtual b32		Initialize(
#ifdef DX
		HWND h_wnd
#endif
		);
	virtual void	Finalize();

	virtual b32		GetState( vec2f& out_pos, u32& out_state );

#ifdef GL
	static void		CallbackInput( int button, int state, int x, int y );
#endif

private:
#ifdef DX
	HWND m_h_wnd;
#else
	static b32 b_button_on_tbl[ input_mouse_def::eNOF_MOUSE_BUTTON ];
	static u32 pos_x, pos_y;
#endif
};



